% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-fs.R
\name{backup_file}
\alias{backup_file}
\title{Back up and rename the file or directory}
\usage{
backup_file(path, remove = FALSE, quiet = FALSE)
}
\arguments{
\item{path}{path to a file or a directory}

\item{remove}{whether to remove the original path; default is false}

\item{quiet}{whether not to verbose the messages; default is false}
}
\value{
\code{FALSE} if nothing to back up, or the back-up path
if \code{path} exists
}
\description{
Back up and rename the file or directory
}
\examples{

path <- tempfile()
file.create(path)

path2 <- backup_file(path, remove = TRUE)

file.exists(c(path, path2))
unlink(path2)


}
