% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class113-recording_blocks_coefs.R
\name{RAVESubjectRecordingBlockTimeFreqBaseRepository}
\alias{RAVESubjectRecordingBlockTimeFreqBaseRepository}
\title{'RAVE' class for loading entire block of time-frequency coefficients}
\description{
'RAVE' class for loading entire block of time-frequency coefficients

'RAVE' class for loading entire block of time-frequency coefficients
}
\seealso{
\code{\link{prepare_subject_with_blocks}}
}
\section{Super classes}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{ravecore::RAVESubjectRepository} -> \code{\link[ravecore:RAVESubjectRecordingBlockRepository]{ravecore::RAVESubjectRecordingBlockRepository}} -> \code{RAVESubjectRecordingBlockTimeFreqBaseRepository}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sample_rates}}{a named list of sampling frequencies; the names
are signal types (\code{'LFP'}, \code{'Auxiliary'}, or \code{'Spike'})
and the values are the sampling frequencies}

\item{\code{sample_rate}}{numeric sample rate for 'spectrogram'}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubjectRecordingBlockTimeFreqBaseRepository-@marshal}{\code{RAVESubjectRecordingBlockTimeFreqBaseRepository$@marshal()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqBaseRepository-@unmarshal}{\code{RAVESubjectRecordingBlockTimeFreqBaseRepository$@unmarshal()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqBaseRepository-new}{\code{RAVESubjectRecordingBlockTimeFreqBaseRepository$new()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqBaseRepository-mount_data}{\code{RAVESubjectRecordingBlockTimeFreqBaseRepository$mount_data()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqBaseRepository-clone}{\code{RAVESubjectRecordingBlockTimeFreqBaseRepository$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRepository" data-id="@get_container"><a href='../../ravecore/html/RAVESubjectRepository.html#method-RAVESubjectRepository-@get_container'><code>ravecore::RAVESubjectRepository$@get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockRepository" data-id="export_matlab"><a href='../../ravecore/html/RAVESubjectRecordingBlockRepository.html#method-RAVESubjectRecordingBlockRepository-export_matlab'><code>ravecore::RAVESubjectRecordingBlockRepository$export_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockRepository" data-id="get_container"><a href='../../ravecore/html/RAVESubjectRecordingBlockRepository.html#method-RAVESubjectRecordingBlockRepository-get_container'><code>ravecore::RAVESubjectRecordingBlockRepository$get_container()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqBaseRepository-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqBaseRepository-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqBaseRepository$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqBaseRepository-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqBaseRepository-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqBaseRepository$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqBaseRepository-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqBaseRepository-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqBaseRepository$new(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  blocks = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE,
  lazy_load = FALSE,
  .class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject}

\item{\code{electrodes}}{string or integers indicating electrodes to load}

\item{\code{reference_name}}{name of the reference table}

\item{\code{blocks}}{name of the recording blocks to load}

\item{\code{...}}{passed to \code{\link{RAVESubjectBaseRepository}} constructor}

\item{\code{quiet}}{see field \code{quiet}}

\item{\code{repository_id}}{see field \code{repository_id}}

\item{\code{strict}}{whether the mode should be strict; default is true and
errors out when subject is missing}

\item{\code{lazy_load}}{whether to delay (lazy) the evaluation \code{mount_data}}

\item{\code{.class}}{internally used, do not set, even if you know what this is}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqBaseRepository-mount_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqBaseRepository-mount_data}{}}}
\subsection{Method \code{mount_data()}}{
function to mount data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqBaseRepository$mount_data(
  ...,
  force = TRUE,
  electrodes = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{reserved}

\item{\code{force}}{force update data; default is true; set to false
to use cache}

\item{\code{electrodes}}{electrodes to update; default is \code{NULL} (all
electrode channels)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqBaseRepository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqBaseRepository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqBaseRepository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
