% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterList.R
\name{rasterList}
\alias{rasterList}
\alias{as.RasterList}
\alias{rasterList,RasterLayer-method}
\alias{rasterList,RasterStack-method}
\alias{rasterList,RasterBrick-method}
\alias{rasterList,RasterList-method}
\title{Creates a \code{\link{RasterList-class}}  object}
\usage{
rasterList(object = NULL, list = NULL, object.name = NA, ...)

as.RasterList(object, ...)

rasterList(object = NULL, list = NULL, object.name = NA, ...)

\S4method{rasterList}{RasterLayer}(object = NULL, list = NULL, object.name = NA, ...)

\S4method{rasterList}{RasterStack}(object = NULL, list = NULL, object.name = NA, ...)

\S4method{rasterList}{RasterBrick}(object = NULL, list = NULL, object.name = NA, ...)

\S4method{rasterList}{RasterList}(object, list = NULL, object.name = NA, FUN = NULL, ...)
}
\arguments{
\item{object}{the object to coerce}

\item{list}{a \code{list} object to assign to the raster map.}

\item{object.name}{character string containing the name to assign to \code{object}.}

\item{...}{further arguments for \code{\link[raster]{raster}}(generic) or \code{FUN} (\code{\link{RasterList-class}})}

\item{FUN}{function that can be used to apply to each element of the list in a \code{\link{RasterList-class}}}
}
\value{
a \code{\link{RasterList-class}} object.
}
\description{
The method \code{rasterList} is the constructor of a  \code{\link{RasterList-class}} from a generic \code{object}.
}
\details{
The argument \code{FUN} is useful to create or transform \code{\link{RasterList-class}} from other Raster* classes.
}
\examples{

f <- system.file("external/test.grd", package="raster")
rr <- rasterList(f) 
rs <- as.RasterList(f)
# The package-provided datasets shall be only used as example datasets. 
precf <- system.file("map/precipitation.grd", package="rasterList")##
## A resampled preciptation raster map based on CHIRS dataset:
## Funk, Chris, Pete Peterson, Martin Landsfeld, Diego Pedreros, James Verdin, 
## Shraddhanand Shukla, Gregory Husak, James Rowland, Laura Harrison, 
## Andrew Hoell and Joel Michaelsen.
## "The climate hazards infrared precipitation with stations - a new environmental 
## record for monitoring extremes". Scientific Data 2, 150066. doi:10.1038/sdata.2015.66 2015. 
## http://chg.geog.ucsb.edu/data/chirps/
##
\dontrun{
if (requireNamespace("lmom",quietly = TRUE) & requireNamespace("lubridate",quietly = TRUE)) {
## Sample L-moments
 library(lmom)
 library(lubridate)
 
prec <- stack(precf)
samlmom <- stack(rasterList(prec,FUN=samlmu))
## Fitting a Random Probability Distribution: it is a 'rasterList' Object
fitdist <- rasterList(samlmom,FUN=pelgam)
}
}

if (requireNamespace("lmom",quietly = TRUE) & requireNamespace("lubridate",quietly = TRUE)) {
library(lmom)
library(lubridate)
precf <- system.file("map/Mekrou_precipitation.grd", package="rasterList")
prec <- stack(precf)
 # Set time
time <- as.Date(names(prec),format="X\%Y.\%m.\%d")
year <- sprintf("X\%04d",lubridate::year(time)) ##as.character(time,format="X\%Y")

## Compute Annual Precipitation (sum aggregration)
yearlyprec <- stackApply(x=prec,fun=sum,indices=year)
## L-moments
samlmom <- stack(rasterList(yearlyprec,FUN=samlmu))
fitdist <- rasterList(samlmom,FUN=pelgam)

}

}
