% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_qsm.R
\name{summarise_qsm}
\alias{summarise_qsm}
\alias{summarize_qsm}
\title{Summarise QSM}
\usage{
summarise_qsm(cylinder, radius, triangulation = NULL)

summarize_qsm(cylinder, radius, triangulation = NULL)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{radius}{Radius column name either quoted or unquoted.}

\item{triangulation}{Optional QSM triangulation list. Only supports TreeQSM.}
}
\value{
Returns a list
}
\description{
Generates a simple QSM summary. The summary includes basic tree
metrics, such as DBH, total height, and also volume and surface area
arranged by totals and branching order.
}
\details{
\code{summarise_qsm()} and \code{summarize_qsm()} are synonyms.
}
\examples{

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)
summarise_qsm(cylinder, radius)

# TreeQSM Triangulation
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_treeqsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
summarise_qsm(cylinder, radius, triangulation = qsm$triangulation)

}
