% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_efforts_list.R
\name{get_efforts_list}
\alias{get_efforts_list}
\title{Get all the efforts in a segment if no queries are specified}
\usage{
get_efforts_list(
  stoken,
  id,
  athlete_id = NULL,
  start_date_local = NULL,
  end_date_local = NULL
)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{character string for id of the segment}

\item{athlete_id}{character string for the athlete id for filtering the results}

\item{start_date_local}{the start date for filtering the results}

\item{end_date_local}{the end date for filtering the results}
}
\value{
Data from an API request.
}
\description{
Get all the efforts in a segment if no queries are specified
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_efforts_list(stoken, id = '229781')
}
}
\concept{token}
