% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{.rp_make_ord_payload}
\alias{.rp_make_ord_payload}
\title{Build Single-Leg Order Payload (Internal)}
\usage{
.rp_make_ord_payload(
  ticker,
  symType,
  orderId = NULL,
  side = NULL,
  ordType = NULL,
  timeInForce = NULL,
  expirationTime = NULL,
  qty = NULL,
  amt = NULL,
  lmtPrc = NULL,
  stopPrc = NULL,
  openCloseIndicator = NULL
)
}
\arguments{
\item{ticker}{= (string) Ticker symbol: ex. 'SPY'}

\item{symType}{= (string) Symbol type: ex. 'EQUITY'}

\item{orderId}{= (string) The order ID}

\item{side}{= (string) The Order Side BUY/SELL. For Options also include the openCloseIndicator}

\item{ordType}{= (string) The Type of order: 'MARKET', 'LIMIT', 'STOP', 'STOP_LIMIT'}

\item{timeInForce}{= (string) The time in for the order: 'DAY' or 'GTD"}

\item{expirationTime}{= (string) The expiration date. Only used when timeInForce is GTD, cannot be more than 90 days in the future}

\item{qty}{= (string) The order quantity. Used when buying/selling whole shares and when selling fractional. Mutually exclusive with amount}

\item{amt}{= (string) The order amount. Used when buying/selling shares for a specific notional value}

\item{lmtPrc}{= (string) The limit price. Used when orderType = LIMIT or orderType = STOP_LIMIT}

\item{stopPrc}{= (string) The stop price. Used when orderType = STOP or orderType = STOP_LIMIT}

\item{openCloseIndicator}{= (string) Used for options only. Indicates if this is BUY to OPEN/CLOSE}
}
\value{
Returns an appropriate payload \code{list} for a single-leg order
}
\description{
Build Single-Leg Order Payload (Internal)
}
\examples{
\dontrun{
  # Return the proper order payload for single-leg orders
  .rp_make_ord_payload(under_sym="IWM", symType = "EQUITY", orderId = rp_getOrderId(), 
                       side="BUY", orderType="LIMIT", timeInForce="GTD", 
                       expirationTime ="2023-11-07T05:31:56Z", qty=1.735, lmtPrc="200.00")
}
}
