% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{.rp_make_opt_symbol}
\alias{.rp_make_opt_symbol}
\title{Build Option Symbol (Internal)}
\usage{
.rp_make_opt_symbol(under_sym, exp, type, strike)
}
\arguments{
\item{under_sym}{= (string) Underlying symbol for the option: ex. 'SPY'}

\item{exp}{= (string) The option expiration: ex. "2025-08-15"}

\item{type}{= (string) The option type: 'C' for Call & 'P' for Put}

\item{strike}{= (double/int) The option strike price: 631 or 631.00}
}
\value{
Returns a valid symbol \code{string} for the option contract of interest
}
\description{
Build Option Symbol (Internal)
}
\examples{
\dontrun{
  # Return the proper option symbol of interest: "TSLA250808C00325000"
  .rp_make_opt_symbol(under_sym="TSLA", exp="2025-08-08", type="C", strike=325)
}
}
