% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocean.R
\name{ocean}
\alias{ocean}
\title{OCEAN algorithm}
\usage{
ocean(
  pm1,
  pm2,
  gCT,
  scale = c("pair", "row", "col"),
  mps,
  nMax = 100,
  verbose = TRUE
)
}
\arguments{
\item{pm1, pm2}{Matrix; Subsets of two omics data sets where rows are the features and columns are samples.
The rows of the two matrices would define the two-way feature set of interest.}

\item{gCT}{Vector; Parameters of the global closed testing, output of simesCT function.}

\item{scale}{Optional character vector; It specifies the scale of TDP quantification.
Possible choices are "pair" (pair-TDP), "col" (col-TDP ) and "row" (for row-TDP').
If not specified, all three scales are returned.}

\item{mps}{Optional matrix of p-values; A sub-matrix of pairwise associations, representing the two-way feature set of interest.
If provided, \code{pm1} and \code{pm2} are not required. If not provided, matrix of pairwise associations will be
derived from \code{pm1} and \code{pm2} based on Pearson's correlation.}

\item{nMax}{Maximum number of steps for branch and bound algorithm, if set to 1 branch and bound
is skipped even if the result is not exact. The default value is a 100. The algorithm may
stop before the \code{nMax} is reached if it converges sooner.}

\item{verbose}{Logical; if \code{TRUE}, progress messages will be displayed during the function's execution. Default is \code{TRUE}.}
}
\value{
TDP is returned for the specified scales, along with number of steps taken and
convergence status for branch and bound algorithm.
}
\description{
Calculates heuristic and lower bound for the true discovery proportion (TDP) in 3 scales for
a specified two-way feature set (Algorithm 1 in the reference).
The input is either two omics data sub-matrices or the pre-calculated matrix of p-values for pairwise associations.
In case the result is not exact, the function adopts branch and bound (Algorithm 2 in the reference), if \code{nMax} allows.
}
\examples{

#number of features per omic data set
n_cols<-100
n_rows<-120

#random matrix of p-values
set.seed(1258)
pvalmat<-matrix(runif(n_rows*n_cols, min=0, max=1)^6, nrow=n_rows, ncol=n_cols)

#calculate CT parameters
gCT<-simesCT(mps=pvalmat, m=nrow(pvalmat)*ncol(pvalmat))

#calculate TDPs for a random feature set
subpmat<-pvalmat[1:40,10:75]

out<-ocean(mps=subpmat, gCT=gCT, nMax=2)
out


}
\seealso{
\link{simesCT}
 \link{pairTDP}
 \link{runbab}
}
