% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCat.R
\name{getCat}
\alias{getCat}
\title{Calculate cumulative p-categories}
\usage{
getCat(mps, gCT, scale = c("col", "row"))
}
\arguments{
\item{mps}{Matrix of p-values, representing pairwise associations between two feature sets.}

\item{gCT}{Parameters of the global closed testing, which is the output of simesCT function.}

\item{scale}{Scale of the quantification, a character string. Possible choices are "col" and "row".}
}
\value{
Matrix of p-categories.
}
\description{
Calculates cumulative p-categories for a given matrix of p-values.
}
\examples{

#number of features per omic data set
n_cols<-100
n_rows<-120

#random matrix of p-values
set.seed(1258)
pvalmat<-matrix(runif(n_rows*n_cols, min=0, max=1)^5, nrow=n_rows, ncol=n_cols)

#calculate CT parameters
gCT<-simesCT(mps=pvalmat, m=nrow(pvalmat)*ncol(pvalmat))

#define the two-way feature set
subpmat<-pvalmat[61:75,81:100]

#calculate p-categories matrix for feature set by rows
rCat<-getCat(mps=subpmat, gCT, scale="row")

#calculate p-categories matrix for feature set by columns
cCat<-getCat(mps=subpmat, gCT, scale="col")

}
\seealso{
\link{simesCT}
}
