% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_natmort.R
\name{est_natmort}
\alias{est_natmort}
\title{Compute meta-analytic estimates of instantaneous and conditional natural mortality}
\usage{
est_natmort(lhparms = NULL, method = "rFAMS", incl.avg = FALSE, ...)
}
\arguments{
\item{lhparms}{A named vector or string returned by \code{lhparms}.}

\item{method}{A string that indicates what methods to use to estimate M (see \code{\link[FSA]{metaM}}).}

\item{incl.avg}{A logical that indicates whether the average cm should be computed from the estimated M of all methods.}

\item{\dots}{Option arguments for parameter values required by methods using parameters other than those in \code{lhparms}. See examples.}
}
\value{
A data.frame with the following items:
\itemize{
\item \code{method}: The name for the method within the function (as given in \code{method}).
\item \code{M}: The estimated instantaneous natural mortality rate (from \code{metaM})
\item \code{cm}: The estimated conditional natural mortality rate (computed directly from \code{M}).
\item \code{givens}: A string that contains the input values required by the method to estimate M.
}
}
\description{
Several methods may be used to estimate instantaneous (M) and conditional natural mortality (cm) from other types of data, especially those saved in the life history parameters vector/list from \code{\link{makeLH}}.
}
\details{
The default \code{method}s to use are all of those listed in \code{\link[FSA]{Mmethods}} that use some of the life history parameters required by \code{makeLH}. These methods are not all equally useful or robust, so the user may want to select a subset of them for use after learning more about them. See references in \code{\link[FSA]{metaM}}.

Other methods that require parameters other than those required by \code{makeLH} can be used by providing the name of the method in \code{method} and the required parameters as arguments, as defined in \code{\link[FSA]{metaM}}. See \code{\link[FSA]{metaM}} for more details and the examples below for an example.
}
\examples{
# An example lhparm as would be returned from makeLH
tmp <- list(N0=100,tmax=15,Linf=500,K=0.3,t0=-0.5,LWalpha=-5.16,LWbeta=3.1)

# All methods in metaM() that use those life history parameters
est_natmort(tmp)

# Same but including the average in the last row
est_natmort(tmp,incl.avg=TRUE)

# Selecting just one method
est_natmort(tmp,method="HoenigNLS")

# Selecting several methods
est_natmort(tmp,method=c("HoenigNLS","HoenigO","HoenigO2","HoenigLM"))

# A method that uses a parameter not usually in lhparms
est_natmort(tmp,method="QuinnDeriso",PS=0.05)

# Selecting all Hoenig methods using Mmethods from FSA
est_natmort(tmp,method=FSA::Mmethods("Hoenig"))

# Over-riding the Linf param in parameters list, but others from tmp
est_natmort(tmp,method="PaulyLNoT")              # Linf from tmp
est_natmort(tmp,Linf=1000/10,method="PaulyLNoT") # Linf from Linf= arg

}
\author{
Derek Ogle
}
