% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveViz.R
\name{saveViz}
\alias{saveViz}
\title{Save a Visualization to File (PDF, PNG, or SVG)}
\usage{
saveViz(
  viz,
  output_dir,
  output_file = "figure_rChEA3",
  format = "pdf",
  with_date = TRUE,
  width = 8,
  height = 5,
  resolution = 300,
  verbose = TRUE
)
}
\arguments{
\item{viz}{A visualization object typically created by
\code{visualizeRank()}, but can also be a \code{ggplot2} plot or
any other plot object printable with \code{print()}.}

\item{output_dir}{A string specifying the output directory. This parameter
is required and has no default.}

\item{output_file}{A string specifying the base filename (without
extension). Defaults to \code{"viz_rChEA3"}.}

\item{format}{Output format. One of \code{"pdf"}, \code{"png"}, or \code{"svg"}.
Defaults to \code{"pdf"}.}

\item{with_date}{Logical (default \code{TRUE}). Whether to prepend the
current date (from \code{today}) to the filename.}

\item{width}{Width of the output file in inches. Default is 8.}

\item{height}{Height of the output file in inches. Default is 5.}

\item{resolution}{Resolution in DPI (only used for PNG). Default is
300.}

\item{verbose}{Logical. If \code{TRUE}, print a message with the saved
path. Default \code{TRUE}.}
}
\value{
The visualization is saved to a file on disk. Invisibly
returns the full path to the saved file.
}
\description{
This function saves a visualization object to a file in the specified
format and directory. It supports visualizations generated by
\code{chea3_visualizeRank()}, \code{ggplot2}, or any other plot object that
can be rendered using \code{print()} inside a graphics device. Optionally,
the current date (stored in the \code{today} variable) can be prepended to
the filename.
}
\examples{
\donttest{
    genes <- c("TP53", "MYC", "STAT3")
    results <- queryChEA3(genes, verbose = FALSE)
    meanRank_res <- results[["Integrated--meanRank"]]

    # Create visualization
    viz <- visualizeRank(meanRank_res)

    # Save as PDF
    saveViz(viz, output_dir = tempdir(), output_file = "chea3_results")

    # Save as PNG with custom dimensions
    saveViz(viz, output_dir = tempdir(), output_file = "chea3_results",
            format = "png", width = 10, height = 6)
}
}
