% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amWaterfall.R
\name{amWaterfall}
\alias{amWaterfall}
\title{Plotting waterfall}
\usage{
amWaterfall(data, start = 0, horiz = FALSE, show_values = FALSE, ...)
}
\arguments{
\item{data}{\code{data.frame}, dataframe with at least 3 columns : 
label (character), value (numeric), operation (character : "plus", "minus", "total").
You can add a third column "color" (character, colors in hexadecimal). You can
also add a column "description" (character) containing the text you want to
display when mouse is on the graphic ('<br>' for a new line).
See \code{\link{data_waterfall}}.}

\item{start}{\code{numeric}, value from which to start.}

\item{horiz}{\code{logical}, TRUE for an horizontal chart, FALSE for a vertical one.}

\item{show_values}{\code{logical}, TRUE to display values on the chart.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amWaterfall computes a waterfall chart of the given value.
}
\examples{
data("data_waterfall")
amWaterfall(data = data_waterfall, show_values = TRUE)

\dontrun{
# Other examples available which can be time consuming depending on your configuration.

# Change the orientation :
amWaterfall(data = data_waterfall, horiz = TRUE)         
}

}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
