% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowpane_tests.R
\name{windowpane_tests}
\alias{windowpane_tests}
\title{Windowpane Tests for Correlation Analysis}
\usage{
windowpane_tests(
  data,
  response_var,
  corr_type = "spearman",
  R = 1000,
  global_alpha = 0.05,
  individual_alpha = 0.005
)
}
\arguments{
\item{data}{A data frame containing the predictors and the response variable.}

\item{response_var}{A string representing the name of the response variable in the data frame.}

\item{corr_type}{A string specifying the correlation method to use; options are "spearman" (default),
"pearson", or "kendall".}

\item{R}{An integer indicating the number of bootstrap replications. Default is 1000.}

\item{global_alpha}{A numeric value representing the global alpha level for the Simes correction.
Default is 0.05.}

\item{individual_alpha}{A numeric value for the individual alpha threshold for testing individual predictors.
Default is 0.005.}
}
\value{
A list containing the following elements:
\item{results}{A data frame with columns: \code{variable}, \code{correlation}, \code{p_value},
\code{mean_corr}, \code{sd_corr}, \code{median_corr}, \code{rank}, \code{simes_threshold},
\code{significant_simes}, and \code{individual_significant}.}
\item{summary_table}{A data frame summarizing the global p-value (\emph{Pg}) and maximum correlation.}
\item{global_significant}{A logical value indicating whether the global test is significant.}
}
\description{
This function performs bootstrapped correlation analysis for multiple predictors against a response variable.
It applies the Simes method for global significance testing and calculates individual correlations,
p-values, and bootstrap statistics.
}
\details{
The function calculates correlations between the response variable and each predictor in the
data frame, using bootstrapping to generate mean, standard deviation, and median estimates of the
correlation. The Simes correction is applied to control for multiple testing, providing a global
p-value (\emph{Pg}). The function also returns the maximum observed correlation.
}
