% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_AFSD.R
\name{plot_AFSD}
\alias{plot_AFSD}
\title{Plot ASFD}
\usage{
plot_AFSD(df)
}
\arguments{
\item{df}{A dataframe containing at least three columns: 'x', 'y', and 'cluster_id'.
'x' and 'y' are spatial coordinates and 'cluster_id' is the cluster identifier
to which each cell belongs.}
}
\value{
A ggplot object with the scatter plot of foci (clusters).
}
\description{
This function creates a tile plot of the foci (cluster) identified by the AFSD function.
It colors each cell in a foci and labels the centroid of each cluster with the foci ID.
The 'ggplot2' package is used for the plot, and will be automatically installed if not already present.
}
\examples{
df <- data.frame(x = sample(1:100, 500, replace = TRUE),
                 y = sample(1:100, 500, replace = TRUE),
                 i = sample(0:1, 500, replace = TRUE, prob = c(0.7, 0.3)))

# Perform the AFSD
result <- AFSD(df)
# Plot the foci
plot_AFSD(result[[3]])

}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{BPL}()},
\code{\link{count_subareas}()},
\code{\link{count_subareas_random}()},
\code{\link{fit_gradients}()},
\code{\link{join_count}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()}
}
\concept{Spatial analysis}
