% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_subareas.R
\name{count_subareas}
\alias{count_subareas}
\title{Count the Number of Ones in Subareas of a Matrix}
\usage{
count_subareas(matrix_data, sub_rows, sub_cols)
}
\arguments{
\item{matrix_data}{A matrix of 0s and 1s to analyze.}

\item{sub_rows}{Number of rows in each subarea.}

\item{sub_cols}{Number of columns in each subarea.}
}
\value{
A matrix where each cell corresponds to a subarea and contains the count of ones.
}
\description{
This function takes a binary matrix (0s and 1s) and divides it into rectangular subareas,
counting the number of ones in each. Subareas are defined by the number of rows and columns
specified by the user. If the matrix dimensions are not perfectly divisible by the subarea size,
edge subareas may be smaller.
}
\examples{
set.seed(123)
mat <- matrix(sample(c(0, 1), 12 * 16, replace = TRUE), nrow = 16, ncol = 12)
count_matrix <- count_subareas(mat, sub_rows = 3, sub_cols = 3)
print(count_matrix)

}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{BPL}()},
\code{\link{count_subareas_random}()},
\code{\link{fit_gradients}()},
\code{\link{join_count}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
