% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFSD.R
\name{AFSD}
\alias{AFSD}
\title{Analysis of foci structure and dynamics (AFSD)}
\usage{
AFSD(df)
}
\arguments{
\item{df}{A dataframe containing at least three columns: 'x', 'y', and 'i'. 'x' and 'y' represent spatial coordinates
and 'i' is a disease indicator (1 if diseased, otherwise 0).}
}
\value{
A list containing:
cluster_summary2: a dataframe summarizing the number and size of foci, and proportions of diseased plants.
cluster_df: a dataframe containing foci information, including size and number of rows and columns in each foci.
df_clustered: the original dataframe with an added 'focus_id' column, showing which foci each row belongs to.
}
\description{
This function performs the analysis of a simple method introduced by Nelson (1996) and expanded by Laranjeira et al. (1998).
The function assumes
the dataframe supplied as input has columns 'x', 'y', and 'i', where 'x' and 'y' are spatial coordinates
and 'i' is a disease indicator variable (1 if diseased, otherwise 0). The function performs several steps
including filtering rows where 'i' is 1, converting to an adjacency matrix, and creating foci using igraph.
It then calculates various statistics about the foci and returns these in a list.
}
\examples{
# Generate a sample dataframe
set.seed(123)
df <- data.frame(x = sample(1:100, 500, replace = TRUE),
                 y = sample(1:100, 500, replace = TRUE),
                 i = sample(0:1, 500, replace = TRUE, prob = c(0.7, 0.3)))

# Perform the AFSD
result <- AFSD(df)

}
\seealso{
Other Spatial analysis: 
\code{\link{BPL}()},
\code{\link{count_subareas}()},
\code{\link{count_subareas_random}()},
\code{\link{fit_gradients}()},
\code{\link{join_count}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
