% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{corp_by}
\alias{corp_by}
\title{Bivariate Correlations with Significant Symbols by Group}
\usage{
corp_by(
  data,
  vrb.nm,
  grp.nm,
  use = "pairwise.complete.obs",
  method = "pearson",
  sep = ".",
  digits = 3L,
  p.10 = "",
  p.05 = "*",
  p.01 = "**",
  p.001 = "***",
  lead.zero = FALSE,
  trail.zero = TRUE,
  plus = FALSE,
  diags = FALSE,
  lower = TRUE,
  upper = FALSE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{use}{character vector of length 1 specifying how to handle missing data
when computing the correlations. The options are 1)
"pairwise.complete.obs", 2) "complete.obs", 3) "na.or.complete", 4)
"all.obs", or 5) "everything". See details of \code{\link[stats]{cor}}.}

\item{method}{character vector of length 1 specifying the type of
correlations to be computed. The options are 1) "pearson", 2) "kendall", or
3) "spearman". See details of \code{\link[stats]{cor}}.}

\item{sep}{character vector of length 1 specifying the string to combine the
group values together with. \code{sep} is only used if there are multiple
grouping variables (i.e., \code{length(grp.nm)} > 1).}

\item{digits}{integer vector of length 1 specifying the number of decimals to
round to.}

\item{p.10}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .10 level.}

\item{p.05}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .05 level.}

\item{p.01}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .01 level.}

\item{p.001}{character vector of length 1 specifying which symbol to append
to the end of any correlation significant at the p < .001 level.}

\item{lead.zero}{logical vector of length 1 specifying whether to retain a
zero in front of the decimal place.}

\item{trail.zero}{logical vector of length 1 specifying whether to retain
zeros after the decimal place (due to rounding).}

\item{plus}{logical vector of length 1 specifying whether to include a plus
sign in front of positive correlations (minus signs are always in front of
negative correlations).}

\item{diags}{logical vector of length 1 specifying whether to retain the
values in the diagonal of the correlation matrix. If TRUE, then the
diagonal will be 1s with \code{digits} number of zeros after the decimal
place (and no significant symbols). If FALSE, then the diagonal will be NA.}

\item{lower}{logical vector of length 1 specifying whether to retain the
lower triangle of the correlation matrix. If TRUE, then the lower triangle
correlations and their significance symbols are retained. If FAlSE, then
the lower triangle will all be NA.}

\item{upper}{logical vector of length 1 specifying whether to retain the
upper triangle of the correlation matrix. If TRUE, then the upper triangle
correlations and their significance symbols are retained. If FAlSE, then
the upper triangle will all be NA.}
}
\value{
list of data.frames containing the correlation coefficients and their
  appended significance symbols based upon their associated p-values. The
  listnames are the unique combinations of the grouping variables, separated
  by "sep" if multiple grouping variables (i.e., \code{length(grp.nm)} > 1)
  are input: \code{unique(interaction(data[grp.nm], sep = sep))}. For each
  data.frame, the rownames and colnames = \code{vrb.nm}. The significance
  symbols are specified by the arguments \code{p.10}, \code{p.05},
  \code{p.01}, and \code{p.001}, after the correlation value. The specific
  elements of the return object are determined by the other arguments.
}
\description{
\code{corp_by} computes a correlation data.frame for each group within
numeric data. The correlation coefficients are appended by their significant
symbols based on their associated p-values. If only the correlation
coefficients are desired, use \code{cor_by} which returns a list of numeric
matrices. \code{corp_by} is simply \code{corp} + \code{by2}.
}
\examples{

# one grouping variable
corp_by(airquality, vrb.nm = c("Ozone","Solar.R","Wind"), grp.nm = "Month")
corp_by(airquality, vrb.nm = c("Ozone","Solar.R","Wind"), grp.nm = "Month",
   use = "complete.obs", method = "spearman")

# two grouping variables
corp_by(mtcars, vrb.nm = c("mpg","disp","drat","wt"), grp.nm = c("vs","am"))
corp_by(mtcars, vrb.nm = c("mpg","disp","drat","wt"), grp.nm = c("vs","am"),
   use = "complete.obs", method = "spearman", sep = "_")

}
\seealso{
\code{\link{corp}}
   \code{\link{cor_by}}
   \code{\link[stats]{cor}}
}
