% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{cor_by}
\alias{cor_by}
\title{Correlation Matrix by Group}
\usage{
cor_by(
  data,
  vrb.nm,
  grp.nm,
  use = "pairwise.complete.obs",
  method = "pearson",
  sep = ".",
  check = TRUE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{use}{character vector of length 1 specifying how to handle missing data
when computing the correlations. The options are 1)
"pairwise.complete.obs", 2) "complete.obs", 3) "na.or.complete", 4)
"all.obs", or 5) "everything". See details of \code{\link[stats]{cor}}.}

\item{method}{character vector of length 1 specifying the type of
correlations to be computed. The options are 1) "pearson", 2) "kendall", or
3) "spearman". See details of \code{\link[stats]{cor}}.}

\item{sep}{character vector of length 1 specifying the string to combine the
group values together with. \code{sep} is only used if there are multiple
grouping variables (i.e., \code{length(grp.nm)} > 1).}

\item{check}{logical vector of length 1 specifying whether to check the
structure of the input arguments. For example, check whether
\code{data[vrb.nm]} are all mode numeric. This argument is available to
allow flexibility in whether the user values informative error messages
(TRUE) vs. computational efficiency (FALSE).}
}
\value{
list of numeric matrices containing the correlations from each group.
  The listnames are the unique combinations of the grouping variables,
  separated by "sep" if multiple grouping variables (i.e.,
  \code{length(grp.nm)} > 1) are input:
  \code{unique(interaction(data[grp.nm], sep = sep))}. The rownames and
  colnames of each numeric matrix are \code{vrb.nm}.
}
\description{
\code{cor_by} computes a correlation matrix for each group within numeric
data. Only the correlation coefficients are determined and not any NHST
information. If that is desired, use \code{\link{corp_by}} which includes
significance symbols. \code{cor_by} is simply \code{cor} + \code{by2}.
}
\examples{

# one grouping variable
cor_by(airquality, vrb.nm = c("Ozone","Solar.R","Wind"), grp.nm = "Month")
cor_by(airquality, vrb.nm = c("Ozone","Solar.R","Wind"), grp.nm = "Month",
   use = "complete.obs", method = "spearman")

# two grouping variables
cor_by(mtcars, vrb.nm = c("mpg","disp","drat","wt"), grp.nm = c("vs","am"))
cor_by(mtcars, vrb.nm = c("mpg","disp","drat","wt"), grp.nm = c("vs","am"),
   use = "complete.obs", method = "spearman", sep = "_")

}
\seealso{
\code{\link[stats]{cor}} for full sample correlation matrixes,
   \code{\link{corp}} for full sample correlation data.frames with significance symbols,
   \code{\link{corp_by}} for full sample correlation data.farmes with significance symbols
   by group.
}
