% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{add_sig}
\alias{add_sig}
\title{Add Significance Symbols to a (Atomic) Vector, Matrix, or Array}
\usage{
add_sig(
  x,
  p,
  digits = 3,
  p.10 = "",
  p.05 = "*",
  p.01 = "**",
  p.001 = "***",
  lead.zero = FALSE,
  trail.zero = TRUE,
  plus = FALSE
)
}
\arguments{
\item{x}{double numeric vector of effect sizes for which statistical
significance is available.}

\item{p}{double matrix of p-values for the effect sizes in \code{x} that are
matched by element index for vectors, by row and column index with
matrices, by row, column, and layer index for 3D arrays, etc. For example,
the p-value in the first row and second column of \code{p} is associated
with the effect size in the first row and second column of \code{x}. If
\code{x} and \code{p} do not have the same dimensions, an error is
returned.}

\item{digits}{integer vector of length 1 specifying the number of decimals to
round to.}

\item{p.10}{character vector of length 1 specifying which symbol to append to
the end of any effect size significant at the p < .10 level.}

\item{p.05}{character vector of length 1 specifying which symbol to append to
the end of any effect size significant at the p < .05 level.}

\item{p.01}{character vector of length 1 specifying which symbol to append to
the end of any effect size significant at the p < .01 level.}

\item{p.001}{character vector of length 1 specifying which symbol to append
to the end of any effect size significant at the p < .001 level.}

\item{lead.zero}{logical vector of length 1 specifying whether to retain a
zero in front of the decimal place if the effect size is within 1 or -1.}

\item{trail.zero}{logical vector of length 1 specifying whether to retain
zeros after the decimal place (due to rounding).}

\item{plus}{logical vector of length 1 specifying whether to include a plus
sign in front of positive effect sizes (minus signs are always in front of
negative effect sizes).}
}
\value{
character vector, matrix, or array with the same dimensions as
  \code{x} and \code{p} containing the effect sizes with their significance
  symbols appended to the end of each value.
}
\description{
\code{add_sig} adds symbols for various p-values cutoffs of statistical
significance. The function inputs a numeric vector, matrix, or array of
effect sizes (e.g., correlation matrix) and a numeric vector, matrix, or
array of p-values that correspond to the effect size (i.e., each row and
column match) and then returns a character vector, matrix, or array of effect
sizes with appended significance symbols. One of the primary applications of
this function is use within \code{\link{corp}} \code{\link{corp_by}}, and
\code{\link{corp_ml}} for correlation matrices.
}
\details{
There are several functions out there that do similar things. Here is one
posted to R-bloggers that does it for correlation matrices using the
\code{corr} function from the \code{Hmisc} package:
\href{https://www.r-bloggers.com/2020/07/create-a-publication-ready-correlation-matrix-with-significance-levels-in-r/}{Click
Here}.
}
\examples{

corr_test <- psych::corr.test(mtcars[1:5])
r <- corr_test[["r"]]
p <- corr_test[["p"]]
add_sig(x = r, p = p)
add_sig(x = r, p = p, digits = 2)
add_sig(x = r, p = p, lead.zero = TRUE, trail.zero = FALSE)
add_sig(x = r, p = p, plus = TRUE)
noquote(add_sig(x = r, p = p)) # no quotes for character elements

}
