% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed_tree_distmap.R
\name{seed_tree_distmap}
\alias{seed_tree_distmap}
\title{Distance map to nearest seed source}
\usage{
seed_tree_distmap(raster, species)
}
\arguments{
\item{raster}{Raster data set with tree species classification of specific
tree species and tree species groups.}

\item{species}{Represents the numerical value by which the tree species of
interest is encoded in the raster data set.}
}
\value{
A SpatRaster object containing the distances to seed source.
The object has the same resolution and extent as the input raster.
}
\description{
Creation of a distance map for the study area. The distance to
the nearest seed source is calculated for every raster cell.
}
\examples{
## Create raster data set
 rr <- terra::rast(
 matrix(sample(0:10, 20 * 20, replace = TRUE),
        nrow = 20, ncol = 20))

## Compute distance for study area
distance <- seed_tree_distmap(raster = rr, species = "10")

## Plot the seed_tree_distmap
terra::plot(distance)

}
