% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{mutate.corpus}
\alias{mutate.corpus}
\alias{transmute.corpus}
\title{Create or transform document variables}
\usage{
\method{mutate}{corpus}(.data, ...)

\method{transmute}{corpus}(.data, ...)
}
\arguments{
\item{.data}{a \pkg{quanteda} object whose document variables will be created
or transformed}

\item{...}{name-value pairs of expressions for document variable modification
or assignment; see \link[dplyr:mutate]{mutate}.}
}
\value{
A corpus with new or modified document variables.
}
\description{
\code{mutate()} adds new \link[quanteda:docvars]{document variables} and preserves
existing ones; \code{transmute()} adds new document variables and drops existing
ones. Both functions preserve the number of rows of the input. New variables
overwrite existing variables of the same name.
}
\examples{
data_corpus_inaugural \%>\%
  mutate(fullname = paste(FirstName, President, sep = ", ")) \%>\%
  summary(n = 5)

data_corpus_inaugural \%>\%
  transmute(fullname = paste(FirstName, President, sep = ", ")) \%>\%
  summary(n = 5)
}
