% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter.corpus}
\alias{filter.corpus}
\title{Return documents with matching conditions}
\usage{
\method{filter}{corpus}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{a \pkg{quanteda} object whose documents will be filtered}

\item{...}{Logical predicates defined in terms of the document variables in
\code{.data}, or a condition supplied externally whose length matches \verb{the number of }ndoc(.data)`.  See \link[dplyr:filter]{filter}.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
A corpus containing only documents that satisfy the specified
conditions.
}
\description{
Use \code{filter()} to select documents where conditions evaluated on document
variables are true. Documents where the condition evaluates to \code{NA} are
dropped. A tidy replacement for \link[quanteda:corpus_subset]{corpus_subset()}.
}
\examples{
data_corpus_inaugural \%>\%
    filter(Year < 1810) \%>\%
    summary()

}
