% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_cols.R, R/mutate.R, R/pull.R,
%   R/relocate.R, R/rename.R, R/select.R
\name{dplyr_cols}
\alias{dplyr_cols}
\alias{mutate}
\alias{transmute}
\alias{pull}
\alias{relocate}
\alias{rename}
\alias{rename_with}
\alias{select}
\title{Verbs that operate on columns}
\arguments{
\item{.data}{a \pkg{quanteda} corpus object}

\item{...}{additional arguments passed to methods}
}
\value{
A corpus with modified document variables, or for \code{pull()}, a vector.
}
\description{
These functions operate on the columns (document variables) of \pkg{quanteda}
objects, creating, modifying, renaming, reordering, or selecting document
variables.
}
\details{
\code{mutate()} creates new document variables or modifies existing ones.
\code{transmute()} creates new document variables and drops existing ones. See
\code{\link[dplyr:mutate]{dplyr::mutate()}} for more details.

\code{pull()} extracts a single document variable as a vector. See
\code{\link[dplyr:pull]{dplyr::pull()}} for more details.

\code{relocate()} changes the column order of document variables. See
\code{\link[dplyr:relocate]{dplyr::relocate()}} for more details.

\code{rename()} changes the names of individual document variables using
\code{new_name = old_name} syntax. \code{rename_with()} renames document variables
using a function. See \code{\link[dplyr:rename]{dplyr::rename()}} for more details.

\code{select()} keeps or drops document variables by name. See \code{\link[dplyr:select]{dplyr::select()}}
for more details.
}
\keyword{internal}
