% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qk_to_latlong_functions.R
\name{quadkey_to_tileXY}
\alias{quadkey_to_tileXY}
\title{Convert a QuadKey into tile XY coordinates.}
\usage{
quadkey_to_tileXY(quadkey)
}
\arguments{
\item{quadkey}{A QuadKey as a single string.}
}
\value{
A list returning the tile X, tile Y coordinates and
the zoom level.
}
\description{
For further information, refer to the
Microsoft Bing Maps Tile System documentation.
}
\details{
Converting latitude/longitude coordinates into a QuadKey
and then back to latitude/longitude won't yield identical values,
unless the initial latitude/longitude coordinates
correspond to the upper-left QuadKey's pixel and tile XY coordinates
at the same zoom level.

Understanding this distinction is crucial for
the accurate use of these functions in coordinate conversions.

For a detailed explanation on how to use this
and other similar \code{quadkeyr} functions,
read the the vignette:
\url{https://docs.ropensci.org/quadkeyr/articles/quadkey_to_sf_conversion.html}
}
\examples{

quadkey_to_tileXY(quadkey = "213")

}
\references{
\url{https://learn.microsoft.com/en-us/bingmaps/articles/bing-maps-tile-system}
}
