% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch3b.R
\docType{data}
\name{ch3b}
\alias{ch3b}
\title{Data with bad markers}
\format{
An object of class \code{cross}.  See \code{\link[qtl:read.cross]{qtl::read.cross()}}
for details.
}
\source{
Karl W Broman, \email{broman@wisc.edu}
}
\usage{
ch3b
}
\description{
Anonymous data with markers showing severe segregation distortion.
}
\details{
An intercross with 144 individuals, each with one phenotype and typed at 145
markers.
}
\examples{

data(ch3b)

library(qtl)
thetab <- geno.table(ch3b)
plot(-log10(thetab[,ncol(thetab)]), ylab=expression(-log[10](P)))
thetab[thetab[,ncol(thetab)] < 1e-6,]

}
\references{
Broman, K. W. and Sen, S. (2009) \emph{A Guide to QTL Mapping
with R/qtl.} Springer, New York.
}
\seealso{
\code{\link{ch3a}}, \code{\link{ch3c}}
}
\keyword{datasets}
