% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DunnettGLM.R
\name{Dunnett.GLM}
\alias{Dunnett.GLM}
\title{Dunnett.GLM}
\usage{
Dunnett.GLM(
  groups,
  counts,
  control.name = NULL,
  zero.treatment.action = "identity.link",
  show.output = TRUE
)
}
\arguments{
\item{groups}{Group vector}

\item{counts}{Vector with count data}

\item{control.name}{Character string with control group name (optional)}

\item{zero.treatment.action}{Method for dealing with treatments only containing zeros (use either
"identity.link" or "log(x+1)"). The method is only used if the data set contains dose/concentration
groups that exclusively contain zero values (since the basic method provides for a logarithmic
transformation of the data averages, it would lead to incorrect results). To deal with this
methodological shortcoming, two options were implemented. The 'identity.link' option: the 'identity'
link is used in the GLM instead of the 'log' link, i.e. the data are no longer transformed. The 'log(x+1)'
option: The 'log' link is retained and 1 is added to each count value at the start of the procedure so
that the subsequent log-transformation can be carried out without any problems. Note that both options
may slightly distort the results.}

\item{show.output}{Show/hide output}
}
\value{
R object with results and information from Dunnett.GLM calculations
}
\description{
When conducting statistical tests with multiple treatments, such as a control group and
increasing concentrations of a test substance, ANOVA and parametric post-hoc tests (e.g. Dunnett's test)
are commonly used. However, these tests require the assumptions of homogeneous variances and normally
distributed data. For count data (e.g. counts of animals), these assumptions are typically violated,
as the data are usually Poisson-distributed. The Dunnett.GLM function is based on a GLM followed by a
Dunnett test to the model estimates. It was implemented to serve as an alternative approach to CPCAT
while using a Quasi-Poisson regression.
The basic approach from Hothorn and Kluxen (2020) was adjusted to overcome methodological issues (see
description of 'zero.treatment.action parameter').
For details on the structure of the input data, please refer to the dataset 'Daphnia.counts' provided
alongside this package.
}
\examples{
Daphnia.counts	# example data provided alongside the package

# Test Dunnett.GLM with 'identity.link' option
Dunnett.GLM(groups = Daphnia.counts$Concentration,
			   counts = Daphnia.counts$Number_Young,
			   control.name = NULL,
			   zero.treatment.action = "identity.link",
			   show.output = TRUE)

# Test Dunnett.GLM with 'log(x+1)' option
Dunnett.GLM(groups = Daphnia.counts$Concentration,
		   counts = Daphnia.counts$Number_Young,
		   control.name = NULL,
		   zero.treatment.action = "log(x+1)",
		   show.output = TRUE)
}
\references{
Hothorn, L.; Kluxen, F. (2020): Statistical analysis of no observed effect concentrations or levels in eco-toxicological assays with overdispersed count endpoints. In: bioRxiv, 2020, https://doi.org/10.1101/2020.01.15.907881
}
