% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_marker_test.R
\name{mapSets}
\alias{mapSets}
\title{Map Sets to rsids}
\usage{
mapSets(sets = NULL, rsids = NULL, Glist = NULL, index = TRUE)
}
\arguments{
\item{sets}{A list of character vectors where each vector represents a set of items. If the names
of the sets are not provided, they are named as "Set1", "Set2", etc.}

\item{rsids}{A character vector of RSIDs. If `Glist` is provided, this parameter is ignored.}

\item{Glist}{A list containing an element `rsids` which is a character vector of RSIDs.}

\item{index}{A logical. If `TRUE` (default), it returns indices of RSIDs; otherwise, it returns the RSID names.}
}
\value{
A list where each element represents a set and contains matched RSIDs or their indices.
}
\description{
This function maps sets to rsids. If a `Glist` is provided, `rsids` are extracted from the `Glist`.
It returns a list of matched RSIDs for each set.
}
\keyword{internal}
