% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_methods.R
\name{qbrms-model-criteria}
\alias{qbrms-model-criteria}
\alias{waic}
\alias{loo}
\alias{dic}
\alias{waic.qbrms_fit}
\alias{loo.qbrms_fit}
\alias{dic.qbrms_fit}
\title{Model comparison criteria for qbrms models}
\usage{
waic(object, ...)

loo(object, ...)

dic(object, ...)

\method{waic}{qbrms_fit}(object, ...)

\method{loo}{qbrms_fit}(object, ...)

\method{dic}{qbrms_fit}(object, ...)
}
\arguments{
\item{object}{A \code{qbrms_fit} object.}

\item{...}{Additional arguments passed to internal methods or underlying tools.}
}
\value{
For \code{dic()}, \code{loo()} and \code{waic()} methods on
\code{qbrms_fit} objects, a list containing the corresponding criterion
(for example, \code{list(dic = ...)}, \code{list(looic = ..., elpd_loo = ...)},
or \code{list(waic = ...)}). If the criterion cannot be computed, \code{NA_real_}
is returned.
}
\description{
Compute approximate DIC, LOO and WAIC for qbrms model fits.
}
\details{
These functions provide generic interfaces (\code{dic()}, \code{loo()}, \code{waic()})
and S3 methods for \code{qbrms_fit} objects that extract the corresponding
criteria from the underlying INLA fit where available.
}
