% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_visualisation.R
\name{prior_predictive_check}
\alias{prior_predictive_check}
\title{Create Prior Predictive Distribution Plot}
\usage{
prior_predictive_check(formula, data, family, prior, n_samples = 1000)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame (used for structure, not values)}

\item{family}{Model family}

\item{prior}{Prior specification}

\item{n_samples}{Number of prior predictive samples (default: 1000)}
}
\value{
A ggplot object showing the prior predictive distribution
}
\description{
Generate predictions from the prior distribution to assess whether
priors are reasonable before seeing the data.
}
\examples{
\dontrun{
prior_predictive_check(
  mpg ~ hp + wt,
  data = mtcars,
  family = gaussian(),
  prior = prior(normal(0, 10), class = "b")
)
}

}
