% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_fields.R
\name{delete_fields}
\alias{delete_fields}
\title{Delete field(s) in a table}
\usage{
delete_fields(subdomain, auth, table_id, field_ids, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{table_id}{Character vector with one element. Found in the URL of a
Quickbase table.}

\item{field_ids}{Character or numeric vector. Field identifier for fields to delete.}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A tibble with the status of the fields passed to field_ids.
}
\description{
Delete a list of one or more fields in a table.
}
\examples{
\dontrun{
   delete_fields(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              table_id = "bsf5hphe5",
              field_ids = c(40:43, 45))
}
}
