% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_barplot.R
\name{cond_barplot}
\alias{cond_barplot}
\title{Conditional quantile barplot}
\usage{
cond_barplot(
  data,
  x = NULL,
  n = 100,
  min_bin_size = NULL,
  overlap = NULL,
  ncols = NULL,
  fill = "#2f4f4f",
  auto_fill = FALSE,
  show_bins = FALSE,
  type = c("median", "mean"),
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} to be binned}

\item{x}{\code{character} variable name used for the quantile binning}

\item{n}{\code{integer} number of quantile bins.}

\item{min_bin_size}{\code{integer} minimum number of rows/data points that should be
in a quantile bin. If NULL it is initially \code{sqrt(nrow(data))}}

\item{overlap}{\code{logical} if \code{TRUE} the quantile bins will overlap. Default value will be
\code{FALSE}.}

\item{ncols}{The number of column to be used in the layout.}

\item{fill}{The color to use for the bars.}

\item{auto_fill}{If \code{TRUE}, use a different color for each category}

\item{show_bins}{If \code{TRUE}, show the bins on the x-axis.}

\item{type}{The type of statistic to use for the bars.}

\item{...}{Additional arguments to pass to the plot functions}
}
\value{
A \code{list} of ggplot objects.
}
\description{
\code{\link[=cond_barplot]{cond_barplot()}} conditions all variables on \code{x} by quantile binning and
shows the median or mean of the other variables for each \code{x}.
}
\examples{
# plots the expected median conditional on Sepal.Width
cond_barplot(iris, "Sepal.Width", n = 12)

\donttest{

  # plots the expected median
  cond_barplot(iris, "Sepal.Width", n = 12, show_bins = TRUE)

  data("diamonds", package="ggplot2")

  cond_barplot(diamonds[c(1:4, 7)], "carat", auto_fill = TRUE)

  if (require(palmerpenguins)) {
    p <- cond_barplot(penguins[1:7], "body_mass_g", auto_fill = TRUE)
    print(p)

    # compare with qbin_boxplot
    p <- cond_boxplot(penguins[1:7], "body_mass_g", auto_fill = TRUE)
    print(p)
  }
}
}
\seealso{
Other conditional quantile plotting functions: 
\code{\link{cond_boxplot}()},
\code{\link{cond_heatmap}()},
\code{\link{funq_plot}()}
}
\concept{conditional quantile plotting functions}
