% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_countries.R
\name{plot_countries}
\alias{plot_countries}
\title{Plot values on a map at country level}
\usage{
plot_countries(
  data,
  iso_col,
  values_col,
  colors = NULL,
  na_value = "grey",
  title = NULL,
  legend_title = NULL
)
}
\arguments{
\item{data}{A data frame containing the values to be plotted on the map.}

\item{iso_col}{A string specifying the column name in \code{data}
with the ISO 3166-1 (alpha-2) country codes. See
\href{https://www.iso.org/iso-3166-country-codes.html}{ISO 3166 Maintenance Agency}
for details on country codes.}

\item{values_col}{A string specifying the column name in \code{data} with the
values to be plotted.}

\item{colors}{Optional vector of colors used in the gradient scale.}

\item{na_value}{Color for missing values (default is "grey").}

\item{title}{A title for the plot (default is \code{NULL}).}

\item{legend_title}{A title for the legend. Default \code{NULL}, name in the
\code{values_col}.}
}
\value{
A \code{ggplot} object with the plotted countries.
}
\description{
Plots country values on a map using data provided and allows
customisation of various aesthetics, such as colors, legend title, and title.
}
\details{
Extracts an \code{\link[sf:sf]{sf}} object from the \code{\link[giscoR:giscoR-package]{giscoR}} package.
It uses the \code{\link[ggplot2:ggplot2-package]{ggplot2}} package for the representation. Also, it supports the addition
of other \code{\link[ggplot2:ggplot2-package]{ggplot2}} options (see examples).
}
\examples{
# Simulated data trade in Northern America
data("datatrade_NorthAm")
# Mean of internal production for each country
library(dplyr)
data_plot <- datatrade_NorthAm$internal_production \%>\% 
  group_by(reporter) \%>\% 
  summarise(mean_value = mean(value))

head(data_plot)

#Plot
pl <- plot_countries(data = data_plot,
                     iso_col = "reporter",
                     values_col = "mean_value")
pl

# Changing colors and adding other ggplot2 options
library(ggplot2)
pl <- plot_countries(data = data_plot,
                     iso_col = "reporter",
                     values_col = "mean_value",
                     colors = c("white", "lightblue", "darkblue"),
                     title = "Plot internal production",
                     legend_title = "units")
pl + 
  xlim(-170, -20) + ylim(10, 90) +
  theme_bw()
               
}
