% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pzfx.R
\name{write_pzfx}
\alias{write_pzfx}
\title{Write one or more tables to a GraphPad Prism .pzfx file}
\usage{
write_pzfx(
  x,
  path,
  row_names = TRUE,
  x_col = NA,
  x_err = NA,
  n_digits = 2,
  notes = NA,
  subcolumns = 1,
  subcolumn_suffix = ""
)
}
\arguments{
\item{x}{Data frame or named list of data frames to include as Prism tables.}

\item{path}{Path to output file.}

\item{row_names}{Logical or logical vector: include row names as row titles?}

\item{x_col}{Column index or name(s) for X column (0 or NA for none).}

\item{x_err}{Column index or name(s) for X error (0 or NA for none).}

\item{n_digits}{Number of decimal places to display for numeric data. Default: 2.}

\item{notes}{Notes table(s) with columns Name and Value. Default: NA (empty notes).}

\item{subcolumns}{Number of subcolumns for Y data, or "SDN" for mean/SD/N format. Default: 1.}

\item{subcolumn_suffix}{Regex or string identifying grouped subcolumns (e.g., "_[0-9]+$" to group A_1, A_2 as column A). Default: "" (no grouping).}
}
\value{
Invisibly returns `x`.
}
\description{
All parameters except path and notes can be of length 1, or the length of the list of input tables.
}
