% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{perm.generalized.covariance}
\alias{perm.generalized.covariance}
\title{perm.generalized.covariance}
\usage{
perm.generalized.covariance(R1, R2, nperm = 5000)
}
\arguments{
\item{R1}{a numerical vector (typically residuals of the first regression)}

\item{R2}{a numerical vector (typically residuals of the second regression)}

\item{nperm}{the number of permutations (defaults to 5000)}
}
\value{
A list containing the T statistic (T.stat),
permutation.prob: the estimated null probability of independence of R1
and R2, based on the chosen number of permutations,
lower.95.CI and upper.95.CI: the 95\% confidence intervals of the estimated
null probability
}
\description{
This performs a permutation version of the generalized covariance test
(see: generalized.covariance), which tests for conditional independence
of two random variables (Y1, Y2)
conditional of a common set of conditioning variables C; see
Shah, R.D. & Peters, J. (2020).
i.e. Y1 \emph{|} Y2 |C. R1 and R2 are the response residuals
from pairs of any type of appropriate regressions of two dependent variables
(Y1 and Y2) on a set of conditioning variables.

Shah, R.D. & Peters, J. (2020). The hardness of conditional independence
testing and the generalized covariance measure.  The Annals of Statistics
48:1514-1538.
}
\examples{
R1<-residuals(mgcv::gam(X3~X2,data=sim_normal.no.nesting,family=gaussian),
type="response")
R2<-residuals(mgcv::gam(X1~X2,data=sim_normal.no.nesting,family=gaussian),
type="response")

#perm.generalized.covariance function
perm.generalized.covariance(R1,R2,nperm=5000)

}
