% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{MCX2}
\alias{MCX2}
\title{Title Monte Carlo chi-square (MCX2)}
\usage{
MCX2(model.df, n.obs, model.chi.square, n.sim = 10000, plot.result = FALSE)
}
\arguments{
\item{model.df}{the model degrees of freedom}

\item{n.obs}{the number of observations (lines) in the data set}

\item{model.chi.square}{the maximum likelihood chi-squared statistic}

\item{n.sim}{the number of independent simulation runs}

\item{plot.result}{a graphical output of the result}
}
\value{
A list containing MCprobability (Monte carlo null probability),
and MLprobability (maximum likelihood probability)
}
\description{
The maximum likelihood chi-square statistic that
is commonly calculated in structural equations modelling only
asymptotically follows a theoretical chi-squared distribution;
with small sample sizes it can deviate enough from the theoretical
distribution to make it problematic.This function estimates the
empirical probability distribution of the Maximum Likelihood
Chi-Square statistic, given a fixed sample size and degrees of
freedom, and outputs the estimated null probability given this
sample size and degrees of freedom.
}
\examples{
MCX2(model.df=10,n.obs=15,model.chi.square=18.2,plot.result=TRUE)
}
