% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes-package.R
\docType{package}
\name{pvEBayes-package}
\alias{pvEBayes-package}
\title{A suite of empirical Bayes methods to use in pharmacovigilance.}
\description{
\code{pvEBayes} provides a collection of parametric and non-parametric
empirical Bayes methods implementation for pharmacovigilance (including
signal detection and signal estimation) on spontaneous reporting systems
(SRS) data.

An SRS dataset catalogs AE reports on \emph{I} AE rows across \emph{J} drug columns.
Let \eqn{N_{ij}} denote the number of reported cases for the
\emph{i}-th AE and the \emph{j}-th drug, where \eqn{i = 1,..., I} and
\eqn{j = 1,..., J}. We assume that for each AE-drug pair,
\eqn{N_{ij} \sim \text{Poisson}(\lambda_{ij} E_{ij})}, where \eqn{E_{ij}} is
expected baseline value measuring the expected count of the AE-drug pair
when there is no association between \emph{i}-th AE and \emph{j}-th drug. The parameter
\eqn{\lambda_{ij} \geq 0} represents the relative reporting ratio, the signal
strength, for the \eqn{(i, j)}-th pair measuring the ratio of the actual
expected count arising due to dependence to the null baseline expected count.
Current disproportionality analysis mainly focuses on \emph{signal detection}
which seeks to determine whether the observation \eqn{N_{ij}} is substantially
greater than the corresponding null baseline \eqn{E_{ij}}. Under the Poisson
model, that is to say, its signal strength \eqn{\lambda_{ij}} is
significantly greater than 1.

In addition to \emph{signal detection}, Tan et al. (\emph{Stat. in Med.}, 2025) broaden
the role of disproportionality to \emph{signal estimation}. The use of the flexible
non-parametric empirical Bayes models enables more nuanced empirical Bayes
posterior inference (parameter estimation and uncertainty quantification) on
signal strength parameter \eqn{\{ \lambda_{ij} \}}. This allows researchers to
distinguish AE-drug pairs that would appear similar under a binary signal
detection framework. For example, the AE-drug pairs with signal strengths of
1.5 and 4.0 could both be significantly greater than 1 and detected as a
signal. Such differences in signal strength may have distinct implications in
medical and clinical contexts.

The methods included in \code{pvEBayes} differ by their assumptions on the
prior distribution. Implemented methods include the Gamma-Poisson Shrinker
(GPS), Koenker-Mizera (KM) method, Efron’s nonparametric empirical Bayes
approach, the K-gamma model, and the general-gamma model.

The GPS model uses two gamma mixture prior by assuming the signal/non-signal
structure in SRS data. However, in real-world setting, signal
strengths \eqn{(\lambda_{ij})} are often heterogeneous and thus follows a
multi-modal distribution, making it difficult to assume a parametric prior.
Non-parametric empirical Bayes models (KM, Efron, K-gamma and general-gamma)
address this challenge by utilizing a flexible prior with general mixture
form and estimating the prior distribution in a data-driven way.

\code{pvEBayes} offers the first implemention of the bi-level Expectation
Conditional Maximization (ECM) algorithm proposed by Tan et al. (2025) for
efficient parameter estimation in gamma mixture prior based models: GPS
K-gamma and general-gamma.

The KM method has an existing implementation in the \code{REBayes} package,
but it relies on Mosek, a commercial convex optimization solver, which may
limit accessibility due to licensing issue. \code{pvEBayes} provides a
alternative fully open-source implementation of the KM method using
\code{CVXR}.

Efron’s method also has a general nonparametric empirical Bayes
implementation in the \code{deconvolveR} package; however, that
implementation does not support an exposure or offset parameter in the
Poisson model, which corresponds to the expected null value \eqn{E_{ij}}.
In \code{pvEBayes}, the implementation of the Efron's method is adapted and
modified from \code{deconvolveR} to support \eqn{E_{ij}} in Poisson model.

For an introduction to \code{pvEBayes}, see the vignette.
}
\references{
Tan Y, Markatou M and Chakraborty S. Flexible Empirical Bayesian Approaches
to Pharmacovigilance for Simultaneous Signal Detection and Signal Strength
Estimation in Spontaneous Reporting Systems Data.
\emph{Statistics in Medicine.} 2025; 44: 18-19,
https://doi.org/10.1002/sim.70195.

Tan Y, Markatou M and Chakraborty S. pvEBayes: An R Package for Empirical
Bayes Methods in Pharmacovigilance.
\emph{arXiv}:2512.01057 (stat.AP). https://doi.org/10.48550/arXiv.2512.01057

Koenker R, Mizera I. Convex Optimization, Shape Constraints, Compound
Decisions, and Empirical Bayes Rules. \emph{Journal of the American
Statistical Association} 2014; 109(506): 674–685,
https://doi.org/10.1080/01621459.2013.869224

Efron B. Empirical Bayes Deconvolution Estimates. \emph{Biometrika} 2016;
103(1); 1-20, https://doi.org/10.1093/biomet/asv068

DuMouchel W. Bayesian data mining in large frequency tables, with an
application to the FDA spontaneous reporting system.
\emph{The American Statistician.} 1999; 1;53(3):177-90.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/YihaoTancn/pvEBayes}
  \item \url{https://yihaotancn.github.io/pvEBayes/}
  \item Report bugs at \url{https://github.com/YihaoTancn/pvEBayes/issues}
}

}
\author{
Yihao Tan, Marianthi Markatou, Saptarshi Chakraborty and Raktim Mukhopadhyay.

Maintainer: Yihao Tan \email{yihaotan@buffalo.edu}
}
