% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{create_site_map}
\alias{create_site_map}
\title{Create a Site Map of Sensors and Sources}
\usage{
create_site_map(sensors, sources, text_size = 12)
}
\arguments{
\item{sensors}{Coordinates for sensor locations.}

\item{sources}{Coordinates for source locations.}

\item{text_size}{Numeric. Font size for labels. Default is 12.}
}
\value{
A patchwork-combined ggplot object: site map + compass rose.
}
\description{
This function generates a site map with an adjacent compass rose.
}
\examples{
source_coords <- c(0, 0, 2.5)

n_sensors <- 8
radius <- 20
z_height <- 2.0

angles <- seq(0, 2 * pi, length.out = n_sensors + 1)[- (n_sensors + 1)]

sensor_coords <- matrix(
  cbind(radius * cos(angles), radius * sin(angles), rep(z_height, n_sensors)),
  ncol = 3
)

create_site_map(sensor_coords, source_coords)
}
