% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{strip_error}
\alias{strip_error}
\title{Strip plots with error bars.}
\usage{
strip_error(data, x, y, size = 0.5)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A categorical variable (the exposure).}

\item{y}{A numerical variable (the outcome or response variable).}

\item{size}{Size of the marker.}
}
\description{
\code{strip_error} constructs strip plots with error bars showing 95% bootstrapped
confidence intervals around mean values.
}
\examples{
data(energy, package = "ISwR")
require(sjlabelled, quietly = TRUE)
energy <- energy |>
  var_labels(
    expend = "Energy expenditure (MJ/day)",
    stature = "Stature"
  )

energy |>
  strip_error(x = stature, y = expend)
}
