% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{gg_star}
\alias{gg_star}
\title{Annotating a plot to display differences between groups.}
\usage{
gg_star(fig, x1, y1, x2, y2, y3, legend = "*", ...)
}
\arguments{
\item{fig}{A gformula object.}

\item{x1}{Position in \code{x} for the start of the horizontal line.}

\item{y1}{Position in \code{y} for the start of the vertical line, below to the horizontal line.}

\item{x2}{Position in \code{x} for the end of the horizontal line.}

\item{y2}{Position in \code{y} where the horizontal line is drawn.}

\item{y3}{Position in \code{y} where the text is added.}

\item{legend}{Character text used for annotating the plot.}

\item{...}{Additional information passed to \code{\link[ggformula]{gf_text}}.}
}
\description{
\code{gg_star} is a function used to display differences between groups (see details).
}
\details{
This function draws an horizontal line from coordinate (\code{x1}, \code{y2})
to coordinate (\code{x2}, \code{y2}). Draws vertical lines below the horizontal line,
towards data, from (\code{x1}, \code{y1}) to (\code{x1}, \code{y2}) and from
(\code{x2}, \code{y1}) to (\code{x2}, \code{y2}). Finally, adds
text above the horizontal line, at the mid point between \code{x1} and \code{x2}.
See examples.
}
\examples{
data(kfm, package = "ISwR")
require(sjlabelled, quietly = TRUE)
data(energy, package = "ISwR")
energy <- energy |>
  var_labels(
    expend = "Energy expenditure (MJ/day)",
    stature = "Stature"
  )

p <- energy |>
  strip_error(x = stature, y = expend)

gg_star(p, x1 = 1, y1 = 13, x2 = 2, y2 = 13.2, y3 = 13.4, "**") +
ylim(0, 13.6)
}
