% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bar_error}
\alias{bar_error}
\title{Bar charts with error bars.}
\usage{
bar_error(data, x, y, alpha = 0.7)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A variable in the data frame.}

\item{y}{A variable in the data frame}

\item{alpha}{Opacity of the colour fill (0 = invisible, 1 = opaque).}
}
\description{
\code{bar_error} constructs bar charts in with error bars showing 95% bootstrapped
confidence intervals around mean values. High of bars represent mean values.
}
\examples{
require(dplyr, quietly = TRUE)
require(sjlabelled, quietly = TRUE)
data(birthwt, package = "MASS")

birthwt <- birthwt |>
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker"))
  ) |>
  var_labels(
    bwt = "Birth weight (g)",
    smoke = "Smoking status"
  )

birthwt |>
  bar_error(x = smoke, y = bwt)
}
