% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_functions.R
\name{keep_all_untreated_subset}
\alias{keep_all_untreated_subset}
\title{Keep All Untreated Subset}
\usage{
keep_all_untreated_subset(data, g, tp, ...)
}
\arguments{
\item{data}{the full dataset}

\item{g}{the current group}

\item{tp}{the current time period}

\item{...}{extra arguments to get the subset correct}
}
\value{
list that contains the following elements:
\itemize{
\item \code{gt_data}: a \code{gt_data_frame} object that contains the
correct subset of data
\item \code{n1}: the number of observations in this subset
\item \code{disidx}: a vector of the correct ids for this subset
}
}
\description{
A function that takes an original data set and keeps all
pre-treatment data for all groups.  For group g, it also includes data
for the current period.

Also, note that if \code{tp} is still a pre-treatment period for group g,
then periods after \code{tp} will also be dropped for group g.  This is a
design choice and is useful especially for estimating placebo
group-time average treatment effects in pre-treatment periods.

A main use case for this function is to compute ATT(g,t)'s using a global
estimation strategy such as imputation in Gardner (2022).
}
