% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quorum.R
\name{reached_quorum_any_district}
\alias{reached_quorum_any_district}
\title{Check if parties reached a quorum in at least one district}
\usage{
reached_quorum_any_district(votes_matrix, quorum_districts)
}
\arguments{
\item{votes_matrix}{votes matrix}

\item{quorum_districts}{Vote threshold a party must reach in \emph{at least}
one district. Used as fraction of total votes within a
district if less than 1, otherwise as number of votes.
Must be greater than 0.}
}
\value{
Logical vector with length equal to the number of lists/parties (\code{votes_matrix}
rows) showing whether they reached the quorum or not.
}
\description{
Base implementation, used by \code{\link[=quorum_functions]{quorum_functions}}.
}
\examples{
(vm = matrix(c(239, 10, 308, 398, 20, 925), nrow = 3))
reached_quorum_any_district(vm, 25)
}
\seealso{
\code{\link[=reached_quorum_total]{reached_quorum_total()}}
}
