% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_relative_targets.R
\name{spec_relative_targets}
\alias{spec_relative_targets}
\title{Specify relative targets}
\usage{
spec_relative_targets(targets, ...)
}
\arguments{
\item{targets}{\code{numeric} vector that specifies targets for each
of the features. If a single \code{numeric} value is specified, then all features
are assigned the same proportion-based target. Note that values
range between 0 and 1 (corresponding to 0\% and 100\% respectively).}

\item{...}{not used.}
}
\value{
An object (\code{\linkS4class{TargetMethod}}) for specifying targets that
can be used with \code{\link[=add_auto_targets]{add_auto_targets()}} and \code{\link[=add_group_targets]{add_group_targets()}}
to add targets to a \code{\link[=problem]{problem()}}.
}
\description{
Specify targets expressed as a proportion (between 0 and 1) of the maximum
level of representation of each feature in the study area.
Please note that proportions
are scaled according to the features' total abundances in the study area
(including any locked out planning units, or planning units with \code{NA}
cost values) using the \code{\link[=feature_abundances]{feature_abundances()}} function.
Note that this function is designed to be used with \code{\link[=add_auto_targets]{add_auto_targets()}}
and \code{\link[=add_group_targets]{add_group_targets()}}.
}
\section{Mathematical formulation}{

This method involves setting target thresholds based on a proportion.
To express this mathematically, we will define the following terminology.
Let \eqn{f} denote the total abundance of a feature (e.g., geographic
range size), and \eqn{a} the relative target for the feature
(per \code{targets}).
Given this terminology, the target threshold (\eqn{t}) for the feature
is calculated as follows.
\deqn{t = f \times a}
}

\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
sim_complex_pu_raster <- get_sim_complex_pu_raster()
sim_complex_features <- get_sim_complex_features()

# create base problem
p0 <-
  problem(sim_complex_pu_raster, sim_complex_features) \%>\%
  add_min_set_objective() \%>\%
  add_binary_decisions() \%>\%
  add_default_solver(verbose = FALSE)

# create problem with targets of 10\% for each feature
p1 <-
  p0 \%>\%
  add_auto_targets(method = spec_relative_targets(targets = 0.1))

# solve problem
s1 <- solve(p1)

# plot solution
plot(s1, main = "solution based on 10\% targets", axes = FALSE)

# targets can also be specified for each feature separately.
# to demonstrate this, we will set a target value for each
# feature based on a random percentage between 10\% and 80\%
target_values <- runif(terra::nlyr(sim_complex_features), 0.1, 0.8)

# create problem with targets defined separately for each feature
p2 <-
  p0 \%>\%
  add_auto_targets(method = spec_relative_targets(targets = target_values))

# solve problem
s2 <- solve(p2)

# plot solution
plot(s2, main = "solution based on varying targets", axes = FALSE)
}
}
\seealso{
To add relative targets directly to a \code{\link[=problem]{problem()}}, see
\code{\link[=add_relative_targets]{add_relative_targets()}}.

Other target setting methods:
\code{\link{spec_absolute_targets}()},
\code{\link{spec_area_targets}()},
\code{\link{spec_duran_targets}()},
\code{\link{spec_interp_absolute_targets}()},
\code{\link{spec_interp_area_targets}()},
\code{\link{spec_jung_targets}()},
\code{\link{spec_max_targets}()},
\code{\link{spec_min_targets}()},
\code{\link{spec_polak_targets}()},
\code{\link{spec_pop_size_targets}()},
\code{\link{spec_rl_ecosystem_targets}()},
\code{\link{spec_rl_species_targets}()},
\code{\link{spec_rodrigues_targets}()},
\code{\link{spec_rule_targets}()},
\code{\link{spec_ward_targets}()},
\code{\link{spec_watson_targets}()},
\code{\link{spec_wilson_targets}()}
}
\concept{methods}
