% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcd-stan-tools.R
\name{pcd_load_stan_functions}
\alias{pcd_load_stan_functions}
\title{Load Stan functions as a string}
\usage{
pcd_load_stan_functions(
  functions = NULL,
  stan_path = primarycensored::pcd_stan_path(),
  wrap_in_block = FALSE,
  write_to_file = FALSE,
  output_file = "pcd_functions.stan"
)
}
\arguments{
\item{functions}{Character vector of function names to load. Defaults to all
functions.}

\item{stan_path}{Character string, the path to the Stan code. Defaults to the
path to the Stan code in the primarycensored package.}

\item{wrap_in_block}{Logical, whether to wrap the functions in a
\verb{functions\{\}} block. Default is FALSE.}

\item{write_to_file}{Logical, whether to write the output to a file. Default
is FALSE.}

\item{output_file}{Character string, the path to write the output file if
write_to_file is TRUE. Defaults to "pcd_functions.stan".}
}
\value{
A character string containing the requested Stan functions
}
\description{
Load Stan functions as a string
}
\seealso{
Tools for working with package Stan functions
\code{\link{pcd_stan_dist_id}()},
\code{\link{pcd_stan_files}()},
\code{\link{pcd_stan_functions}()},
\code{\link{pcd_stan_path}()}
}
\concept{stantools}
