% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{from_to_dates_rates}
\alias{from_to_dates_rates}
\title{Wrapper around `priceR::historical_exchange_rates()` with slight modifications
to structure of inputs and output}
\usage{
from_to_dates_rates(from, to, dates)
}
\arguments{
\item{from}{A currency code (see currencies() for supported codes)}

\item{to}{A currency code}

\item{dates}{A list of date ranges}
}
\value{
A data.frame with two columns: date (of class Date), and rate
    (of class numeric).
}
\description{
Wrapper around `priceR::historical_exchange_rates()` with slight modifications
to structure of inputs and output
}
\examples{
\dontrun{
library(lubridate)
from_to_dates_rates("AUD", "USD", dates = list(today()-10, today()))
}

}
