% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_symptom_score}
\alias{calculate_esc_2024_symptom_score}
\title{Calculate Symptom Score (ESC 2024)}
\usage{
calculate_esc_2024_symptom_score(
  chest_pain_type,
  have_dyspnoea,
  allow_na = TRUE,
  label_have_dyspnoea_no = c("no"),
  label_have_dyspnoea_yes = c("yes"),
  label_have_dyspnoea_unknown = c(NA, NaN),
  label_cpt_no_chest_pain = c("no chest pain"),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{chest_pain_type}{The value of variable in the parameters \code{label_cpt_no_chest_pain},
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{have_dyspnoea}{The value of variable in the parameters \code{label_have_dyspnoea_no},
\code{label_have_dyspnoea_yes} and \code{label_have_dyspnoea_unknown}.}

\item{allow_na}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating whether we can
allow `chest_pain_type` or `have_dyspnoea` to be \code{NA} when calculating the score.
Default: \code{TRUE}}

\item{label_have_dyspnoea_no}{Label(s) for patient having no dyspnoea symptoms.
Default: \code{c("no")}}

\item{label_have_dyspnoea_yes}{Label(s) for patient having dyspnoea symptoms.
Default: \code{c("yes")}}

\item{label_have_dyspnoea_unknown}{Label(s) for patient having unknown dyspnoea symptoms.
Default: \code{c(NA, NaN)}}

\item{label_cpt_no_chest_pain}{Label(s) for patient having no chest pain.
Default: \code{c("no chest pain")}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An integer indicating the symptom score of the patient.
It can also be \code{NA} if both \code{chest_pain_type} and \code{have_dyspnoea} are \code{NA}.
Patients with both nonanginal chest pain and dyspnoea will be given a score of 2
}
\description{
A function used to calculate the symptom score of the patient.
This is used to calculate the pretest
probability of coronary artery disease (CAD) based on the
ESC 2024 guidelines.
}
\examples{
calculate_esc_2024_symptom_score(
  chest_pain_type = "nonanginal",
  have_dyspnoea = "yes",
  allow_na = TRUE
)

calculate_esc_2024_symptom_score(
  chest_pain_type = "nonanginal",
  have_dyspnoea = NA,
  allow_na = FALSE
)

calculate_esc_2024_symptom_score(
  chest_pain_type = "nonanginal",
  have_dyspnoea = NA,
  allow_na = TRUE
)

}
