% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{arg_match0_allow_na}
\alias{arg_match0_allow_na}
\title{Match an argument to a character vector but skip \code{NA}}
\usage{
arg_match0_allow_na(
  arg,
  values,
  arg_nm = rlang::caller_arg(arg),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{arg}{A symbol referring to an argument accepting strings.}

\item{values}{A character vector of possible values that \code{arg} can take.}

\item{arg_nm}{Same as \code{error_arg}.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
The string supplied to \code{arg}.
}
\description{
This is equivalent to \code{\link[rlang]{arg_match}} but skip \code{NA}
}
\examples{
# No error
input = "male"
arg_match0_allow_na(input, values = c("female","male"))

# Allow NA
input = NA
arg_match0_allow_na(input, values = c("female","male"))

# Error as M is not female or male
input = "emale"
try(arg_match0_allow_na(input, values = c("female","male")))
}
\seealso{
\code{\link[rlang]{caller_arg}}, \code{\link[rlang]{stack}}, \code{\link[rlang]{arg_match}}
}
