% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_plot.R
\name{pp_plot}
\alias{pp_plot}
\title{Visualize Distribution: Before vs After}
\usage{
pp_plot(x, y, title = "Distribution Comparison")
}
\arguments{
\item{x}{Numeric vector. The original data.}

\item{y}{Numeric vector. The transformed data.}

\item{title}{String. The main title of the plot.}
}
\value{
A \code{ggplot} object.
}
\description{
Creates a comparison plot to visualize the effect of a transformation.
It displays histograms and density curves for both the original and transformed data.
}
\examples{
# 1. Generate skewed data
x <- rchisq(1000, df = 2)

# 2. Transform it
y <- trans_boxcox(x)

# 3. Visualize
pp_plot(x, y, title = "Box-Cox Transformation Effect")
}
