fit.pweibull<-function(formula, data, L=1, t=NULL, prec=1e-04, max.iter=1000, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
{ 
t.or=t
if (!inherits(formula, "formula")) {
        if (inherits(formula, "data.frame")) 
            warning("You gave a data.frame instead of a formula.")
        stop("formula is not an object of type formula")
    }
    if (!inherits(data, "data.frame")) {
        if (inherits(data, "formula")) 
            warning("You gave a formula instead of a data.frame.")
        stop("data is not an object of type data.frame")
    }
    if (missing(formula)) 
        stop("Missing formula")
    if (missing(data)) 
        stop("Missing data")
    mf <- model.frame(formula, data)
    Y <- mf[[1]]
    if (!inherits(Y, "Surv")) 
        stop("left hand side not a survival object")
    X1 <- model.matrix(formula, data)
    x <- X1[, -1, drop = FALSE]
    time <- Y[, 1]
    delta <- Y[, 2]
    if (is.null(prec)) 
        stop("prec must be specified")
    if (is.null(max.iter)) 
        stop("max.iter must be specified")
    if (!is.logical(lambda.identical))
        stop("lambda.identical must be TRUE or FALSE")
    if (!is.logical(alpha.identical))
        stop("alpha.identical must be TRUE or FALSE")
    if(alpha.fixed!=FALSE){if(alpha.fixed<=0) stop("alpha.fixed must be FALSE or a positive number")}
    if(!is.null(t)){
	t=c(t); if(!is.vector(t)) stop("t must be a vector")
	if (!isTRUE(all.equal(0, t[1]))) 
         stop("first element of t should be 0")
	if (is.unsorted(t)) 
        stop("t should be in increasing order")}
    time <- c(time)
    delta <- c(delta)
    max.iter <- round(max.iter)
    if (length(time) != length(delta)) 
        stop("t and delta don't have the same length")
    if (prec > 1) 
        stop("prec is too high")
    if (max.iter <= 0) 
        stop("max.iter at least 1")
fit.pweibull.fixed<-function(formula, data, t=NULL, prec=1e-02, max.iter=1000, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE, est.var=TRUE)
{ 
estimate.t=TRUE
if(is.null(t)) estimate.t=FALSE
    X1 <- model.matrix(formula, data)
    x <- X1[, -1, drop = FALSE]
    time <- Y[, 1]
    delta <- Y[, 2]
    time <- c(time)
    delta <- c(delta)
	llike.pweibull.cens <- function(theta, time, delta, x, t, t.param=TRUE, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
	{
		beta <- theta[1:ncol(x)]
		if(length(t)==1 & !alpha.fixed)
		{
				lambda <- theta[ncol(x)+1]
				alpha <- theta[ncol(x)+2]
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1])
					alpha <- exp(theta[ncol(x)+2])
				}			
				logf <- log(lambda)+log(alpha)+(alpha-1)*log(time)-lambda*time^alpha
				logS <- -lambda*time^alpha
		}
		if(!alpha.fixed & length(t)>1)
		{
			if(!lambda.identical & !alpha.identical)
			{
				lambda <- theta[ncol(x)+1:length(t)]
				alpha <- theta[ncol(x)+length(t)+1:length(t)]
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1:length(t)])
					alpha <- exp(theta[ncol(x)+length(t)+1:length(t)])
				}
				logf <- as.numeric(dpweibull(time, rate = lambda, alpha = alpha, t = t, log = TRUE))
				logS <- as.numeric(ppweibull(time, rate = lambda, alpha = alpha, t = t, log.p = TRUE, lower.tail=FALSE))
			}
			if(lambda.identical & !alpha.identical)
			{
				lambda <- theta[ncol(x)+1]
				alpha <- theta[ncol(x)+1+1:length(t)]
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1])
					alpha <- exp(theta[ncol(x)+1+1:length(t)])
				}
				logf <- as.numeric(dpweibull(time, rate = rep(lambda, length(t)), alpha = alpha, t = t, log = TRUE))
				logS <- as.numeric(ppweibull(time, rate = rep(lambda, length(t)), alpha = alpha, t = t, log.p = TRUE, lower.tail=FALSE))
			}
			if(!lambda.identical & alpha.identical)
			{
				lambda <- theta[ncol(x)+1:length(t)]
				alpha <- theta[ncol(x)+length(t)+1]
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1:length(t)])
					alpha <- exp(theta[ncol(x)+length(t)+1])
				}
				logf <- as.numeric(dpweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log = TRUE))
				logS <- as.numeric(ppweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
			}
			if(lambda.identical & alpha.identical)
			{
				lambda <- theta[ncol(x)+1]
				alpha <- theta[ncol(x)+2]
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1])
					alpha <- exp(theta[ncol(x)+2])
				}
				logf <- as.numeric(dpweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log = TRUE))
				logS <- as.numeric(ppweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
			}
		}
		if(alpha.fixed!=FALSE)
		{
			if(!lambda.identical)
			{
				lambda <- theta[ncol(x)+1:length(t)]
				alpha <- alpha.fixed
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1:length(t)])
				}
				logf <- as.numeric(dpweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log = TRUE))
				logS <- as.numeric(ppweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
			}
			if(lambda.identical)
			{
				lambda <- theta[ncol(x)+1]
				alpha <- alpha.fixed
				if(t.param)
				{
					lambda <- exp(theta[ncol(x)+1])
				}
				logf <- as.numeric(dpweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log = TRUE))
				logS <- as.numeric(ppweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
			}
		}
		-sum(delta*(logf-logS+x%*%beta)+logS*exp(x%*%beta))
	}
	aux.cox=survreg(Surv(time, delta) ~ x[,,drop=FALSE], dist = "weibull", data=data)	
	if(!alpha.fixed)
	{
		alpha.ini=1/aux.cox$scale
		loglambda.ini=-alpha.ini*rep(coef(aux.cox)[1],ifelse(!lambda.identical,length(t),1))
		logalpha.ini=rep(log(alpha.ini),ifelse(!alpha.identical,length(t),1))
		ini=c(-alpha.ini*coef(aux.cox)[-1], loglambda.ini,logalpha.ini)
		#ini[length(ini)-ifelse(alpha.identical,1,length(t))]=-5
		maxi <- optim(ini, llike.pweibull.cens,
			time=time, delta=delta, x=x, t=t, lambda.identical=lambda.identical, alpha.identical=alpha.identical,
			alpha.fixed=alpha.fixed, control=list(maxit=10000),method="BFGS", hessian=FALSE)
		param<-maxi$par
		param[-(1:ncol(x))]<-exp(maxi$par[-(1:ncol(x))])
		estimate=matrix(param,ncol=1)
		colnames(estimate)="estimate"
		if(est.var)
		{
			hes<-try(sqrt(diag(solve(hessian(llike.pweibull.cens, x0=param, time=time, delta=delta, x=x, t=t, 
			lambda.identical=lambda.identical, alpha.identical=alpha.identical, alpha.fixed=alpha.fixed, t.param=FALSE)))),silent=TRUE)
			if(!grepl("Error", hes)[1])
			{
				estimate=cbind(param, hes)
				colnames(estimate)=c("estimate", "s.e.")
			}
		}
		n.t=0
		if(estimate.t) n.t=length(t)-1
		rownames(estimate)=c(colnames(x), paste("lambda",1:ifelse(!lambda.identical, length(t), 1),sep=""), 
				paste("alpha",1:ifelse(!alpha.identical, length(t), 1),sep=""))
		aa=list(estimate=estimate, logLik=-maxi$value, t=t, AIC=2*maxi$value+2*nrow(estimate)+2*n.t, BIC=2*maxi$value+log(length(time))*nrow(estimate))
		if(est.var) if(grepl("Error", hes)[1]) aa$"warnings"="Standard errors can't be estimated"
	}
	if(alpha.fixed!=FALSE)
	{
		aux.cox=survreg(Surv(time, delta) ~ x[,,drop=FALSE], dist = "weibull", data=data, scale=1/alpha.fixed)	
		loglambda.ini=-alpha.fixed*rep(coef(aux.cox)[1],ifelse(!lambda.identical,length(t),1))
		ini=c(-alpha.fixed*coef(aux.cox)[-1], loglambda.ini)
		#ini[length(ini)]=-5
		maxi <- optim(ini, llike.pweibull.cens,
			time=time, delta=delta, x=x, t=t, lambda.identical=lambda.identical, alpha.identical=alpha.identical,
			alpha.fixed=alpha.fixed, control=list(maxit=10000),method="BFGS")
		param<-maxi$par
		param[-(1:ncol(x))]<-exp(maxi$par[-(1:ncol(x))])
		estimate=matrix(param,ncol=1)
		colnames(estimate)="estimate"
		if(est.var)
		{
			hes<-try(sqrt(diag(solve(hessian(llike.pweibull.cens, x0=param, time=time, delta=delta, x=x, t=t, 
				lambda.identical=lambda.identical, alpha.identical=alpha.identical, alpha.fixed=alpha.fixed, t.param=FALSE)))),silent=TRUE)
			if(!grepl("Error", hes)[1])
			{
				estimate=cbind(param, hes)
				colnames(estimate)=c("estimate", "s.e.")
			}
		}
		rownames(estimate)=c(colnames(x), paste("lambda",1:ifelse(!lambda.identical, length(t), 1),sep=""))
		n.t=0
		if(estimate.t) n.t=length(t)-1
		aa=list(estimate=estimate, logLik=-maxi$value, t=t, AIC=2*maxi$value+2*nrow(estimate)+2*n.t, BIC=2*maxi$value+log(length(time))*nrow(estimate)+log(length(time))*n.t, alpha=alpha.fixed)
		if(est.var) if(grepl("Error", hes)[1]) aa$"warnings"="Standard errors can't be estimated"
	}
	aa
}

fit.pweibull.t<-function(t1, formula, data, theta, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
{
	t=c(0,t1)
    X1 <- model.matrix(formula, data)
    x <- X1[, -1, drop = FALSE]
    time <- Y[, 1]
    delta <- Y[, 2]
    time <- c(time)
    delta <- c(delta)
llike.pweibull.cens.t <- function(t1, theta, time, delta, x, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
{
	t=c(0,t1)
	ll=1e308
	grad=rep(0, length(t1))
	if(!is.unsorted(t))
	{
	beta <- theta[1:ncol(x)]
	if(length(t)==1 & !alpha.fixed)
	{
		lambda <- theta[ncol(x)+1]
		alpha <- theta[ncol(x)+2]
		logf <- log(lambda)+log(alpha)+(alpha-1)*log(time)-lambda*time^alpha
		logS <- -lambda*time^alpha
	}
	if(!alpha.fixed & length(t)>1)
	{
		if(!lambda.identical & !alpha.identical)
		{
			lambda <- theta[ncol(x)+1:length(t)]
			alpha <- theta[ncol(x)+length(t)+1:length(t)]
			logf <- as.numeric(dpweibull(time, rate = lambda, alpha = alpha, t = t, log = TRUE))
			logS <- as.numeric(ppweibull(time, rate = lambda, alpha = alpha, t = t, log.p = TRUE, lower.tail=FALSE))
		}
		if(lambda.identical & !alpha.identical)
		{
			lambda <- theta[ncol(x)+1]
			alpha <- theta[ncol(x)+1+1:length(t)]
			logf <- as.numeric(dpweibull(time, rate = rep(lambda, length(t)), alpha = alpha, t = t, log = TRUE))
			logS <- as.numeric(ppweibull(time, rate = rep(lambda, length(t)), alpha = alpha, t = t, log.p = TRUE, lower.tail=FALSE))
		}
		if(!lambda.identical & alpha.identical)
		{
			lambda <- theta[ncol(x)+1:length(t)]
			alpha <- theta[ncol(x)+length(t)+1]
			logf <- as.numeric(dpweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log = TRUE))
			logS <- as.numeric(ppweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
		}
		if(lambda.identical & alpha.identical)
		{
			lambda <- theta[ncol(x)+1]
			alpha <- theta[ncol(x)+2]
			logf <- as.numeric(dpweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log = TRUE))
			logS <- as.numeric(ppweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
		}
	}
	if(alpha.fixed!=FALSE)
	{
		alpha <- alpha.fixed
		if(!lambda.identical)
		{
			lambda <- theta[ncol(x)+1:length(t)]
			logf <- as.numeric(dpweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log = TRUE))
			logS <- as.numeric(ppweibull(time, rate = lambda, alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
		}
		if(lambda.identical)
		{
			lambda <- theta[ncol(x)+1]
			logf <- as.numeric(dpweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log = TRUE))
			logS <- as.numeric(ppweibull(time, rate = rep(lambda,length(t)), alpha = rep(alpha,length(t)), t = t, log.p = TRUE, lower.tail=FALSE))
		}
	}
	ll=-sum(delta*(logf-logS+x%*%beta)+logS*exp(x%*%beta))
	lambda.aux=lambda
	alpha.aux=alpha
	L=length(t)
	if(lambda.identical) lambda.aux=rep(lambda, L)
	if(alpha.identical | alpha.fixed!=FALSE) alpha.aux=rep(alpha, L)
	ind <- rowSums(outer(time, t, ">="))
	ns=colSums(outer(ind, 2:L, ">="))
	der.a=(-lambda.aux[1:(L-1)]*alpha.aux[1:(L-1)]*t[2:L]^(alpha.aux[1:(L-1)]-1)+lambda.aux[2:L]*alpha.aux[2:L]*t[2:L]^(alpha.aux[2:L]-1))
	grad=ns*der.a
	}
	list("objective"=ll, "gradient"=-grad)
}
const.pweibull.cens.t <- function(t1, theta, time, delta, x, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
{
	t=c(0,t1)
	beta <- theta[1:ncol(x)]
	if(length(t)==1 & !alpha.fixed)
	{
		lambda <- theta[ncol(x)+1]
		alpha <- theta[ncol(x)+2]
	}
	if(!alpha.fixed & length(t)>1)
	{
		if(!lambda.identical & !alpha.identical)
		{
			lambda <- theta[ncol(x)+1:length(t)]
			alpha <- theta[ncol(x)+length(t)+1:length(t)]
		}
		if(lambda.identical & !alpha.identical)
		{
			lambda <- theta[ncol(x)+1]
			alpha <- theta[ncol(x)+1+1:length(t)]
		}
		if(!lambda.identical & alpha.identical)
		{
			lambda <- theta[ncol(x)+1:length(t)]
			alpha <- theta[ncol(x)+length(t)+1]
		}
		if(lambda.identical & alpha.identical)
		{
			lambda <- theta[ncol(x)+1]
			alpha <- theta[ncol(x)+2]
		}
	}
	if(alpha.fixed!=FALSE)
	{
		alpha <- alpha.fixed
		if(!lambda.identical) lambda <- theta[ncol(x)+1:length(t)]
		if(lambda.identical) lambda <- theta[ncol(x)+1]
	}
	lambda.aux=lambda
	alpha.aux=alpha
	L=length(t)
	if(lambda.identical) lambda.aux=rep(lambda, L)
	if(alpha.identical | alpha.fixed!=FALSE) alpha.aux=rep(alpha, L)
	const=NULL
	Jh=NULL
	if(L>2)
	{
		ind <- rowSums(outer(time, t, ">="))
		L2=L-1
		const<- NULL
		for(i in 1:(L2-1)) const<-c(const, t1[i]-t1[(i+1):L2])
		Jh<-matrix(0, nrow=length(const), ncol=length(t1))
		int=0
		for(i in 1:(L2-1))
		{
			h=i:(L2-1)
			Jh[int+h-(i-1),i]=1
			Jh[int+h-(i-1),(i+1):L2] = -diag(length(h))
			int=int+length(h)		
		}
	}
	list("constraints"=const, "jacobian"=Jh)
}
	time1=split(time, delta)$"1"
	qq=quantile(time1,c(0.05,0.95))

	nloptr::nloptr(x0 = t[-1], eval_f = llike.pweibull.cens.t, eval_g_ineq = const.pweibull.cens.t, lb=rep(qq[1],length(t1)),
		ub=rep(qq[2], length(t1)),
            theta=theta, time=time, delta=delta, x=x, lambda.identical=lambda.identical, alpha.identical=alpha.identical, alpha.fixed=alpha.fixed, 
		opts = list("algorithm" = "NLOPT_LD_SLSQP", "xtol_rel"=1e-8))$solution
}
	if(is.null(t))
	{
	if(L>1)
	{
		if(L>2)
		{
			time1=split(time, delta)$"1"
			delta1=rep(1, length(time1))
			qq1=matrix(as.vector(c(quantile(split(time,delta)$"1",c(0.05,0.95)))),nrow=1)
			qq=c()
			aa=quantile(time1,(1:(L-1))/L)
			if(!is.unsorted(aa, strictly=TRUE) & aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2])	qq=matrix(as.vector(c(aa)),nrow=1)
			KK=survfit(Surv(time1, delta1)~1)
			xx=KK$time[-length(KK$time)];yy=-log(KK$surv)[-length(KK$time)]
			lm_model=lm(yy~xx)
			seg_model <- try(segmented(lm_model, seg.Z = ~xx, npsi=L-1),silent=TRUE)
			if(!grepl("Error", seg_model)[1])
			{
				if(!is.null(seg_model$psi) & !is.unsorted(aa, strictly=TRUE) & aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2])
				{ 
					aa=sort(as.vector(seg_model$psi[,2]))
					if(aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2] & !is.unsorted(aa, strictly=TRUE)) qq=rbind(qq,aa)
				}
			}
			#aa=as.vector(c(quantile(time1,(1:(L-1))/(2*L))))
			#if(aa[1]>qq1[1,1] & aa[L-1]<qq1[1,2]) qq=rbind(qq,aa)
			#aa=as.vector(c(quantile(time1,c((1:(L-2))/(3*(L-2)),2/3))))
			#if(aa[1]>qq1[1,1] & aa[L-1]<qq1[1,2]) qq=rbind(qq,aa)
			#aa=as.vector(c(quantile(time1,c((1:(L-2))/(2*(L-2)),3/4))))
			#if(aa[1]>qq1[1,1] & aa[L-1]<qq1[1,2]) qq=rbind(qq,aa)

			KK=survfit(Surv(time, delta)~1)
			xx=KK$time[-length(KK$time)];yy=-log(KK$surv)[-length(KK$time)]
			lm_model=lm(yy~xx)
			seg_model <- try(segmented(lm_model, seg.Z = ~xx, npsi=L-1), silent=TRUE)
			if(!grepl("Error", seg_model)[1])
			{ 
				if(!is.null(seg_model$psi) & !is.unsorted(aa, strictly=TRUE) & aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2])
				{
					aa=sort(as.vector(seg_model$psi[,2]))
					if(aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2]) qq=rbind(qq,aa)
				}
			}
			aa=quantile(time,(1:(L-1))/L)
			if(!is.unsorted(aa, strictly=TRUE) & !is.unsorted(aa, strictly=TRUE) & aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2]) qq=rbind(qq,matrix(as.vector(c(aa)),nrow=1))
			#aa=as.vector(c(quantile(time,(1:(L-1))/(2*L))))
			#if(aa[1]>qq1[1,1] & aa[L-1]<qq1[1,2]) qq=rbind(qq,aa)
			aa=seq(quantile(time, 0.05), quantile(time, 0.95), length=L-1)
			if(!is.unsorted(aa, strictly=TRUE) & !is.unsorted(aa, strictly=TRUE) & aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2]) qq=rbind(qq, aa)
			aa=seq(quantile(time1, 0.05), quantile(time1, 0.95), length=L-1)
			if(!is.unsorted(aa, strictly=TRUE) & !is.unsorted(aa, strictly=TRUE) & aa[1]>qq1[1,1] & aa[length(aa)]<qq1[1,2]) qq=rbind(qq, aa)
			jj=1
			logLik=c()
			tt1=c()

			qq=unique(qq)

			t=as.vector(c(0,qq[1,]))
			aux=try(fit.pweibull.fixed(Surv(time, delta)~x[,,drop=FALSE], data=data, t=t,
				lambda.identical=lambda.identical, alpha.identical=alpha.identical,alpha.fixed=alpha.fixed, est.var=FALSE),silent=TRUE)
			if(!grepl("Error",aux)[1])
			{
				logLik=c(logLik,aux$logLik)
				tt1=rbind(tt1, t[-1])
			}
			while(jj<=nrow(qq))
			{
				t=as.vector(c(0,qq[jj,]))
				iter=1;dif=10
				aux=try(fit.pweibull.fixed(Surv(time, delta)~x[,,drop=FALSE], data=data, t=t,
					lambda.identical=lambda.identical, alpha.identical=alpha.identical,alpha.fixed=alpha.fixed, est.var=FALSE)$estimate[,1],silent=TRUE)
				if(!grepl("Error",aux)[1])
				{
					par.last=c(aux,t[-1])
					flag=0
					while(iter<=max.iter & dif>prec & flag==0)
					{
						flag=1
						aux.t=try(fit.pweibull.t(t[-1], formula, data, theta=aux, lambda.identical, alpha.identical, alpha.fixed),silent=TRUE)
						if(!grepl("Error",aux.t)[1])
						{
							t=c(0,aux.t)
							aux.p=try(fit.pweibull.fixed(formula, data=data, t=t, lambda.identical=lambda.identical, 
								alpha.identical=alpha.identical,alpha.fixed=alpha.fixed, est.var=FALSE),silent=TRUE)
							if(!grepl("Error",aux.p)[1])
							{
								aux=aux.p$estimate[,1]
								par.new=c(aux,t[-1])
								dif=max(abs(par.last-par.new))	
								par.last=par.new
								flag=0
							}
						}
						iter=iter+1
					}
					if(!grepl("Error",aux.p)[1] & !grepl("Error",aux.t)[1])
					{
    						ind <- rowSums(outer(time1, t, ">="))
						if(min(table(c(ind,1:L)-1))>=3)
						{
							logLik=c(logLik,aux.p$logLik)
							tt1=rbind(tt1, t[-1])
						}
					}
				}
				jj=jj+1
			}
			t=as.vector(c(0,tt1[which.max(logLik),]))
		}
		if(L==2)
		{
			t=as.vector(c(0,quantile(split(time,delta)$"1",(1:(L-1))/L)))
			iter=1;dif=10
			aux=try(fit.pweibull.fixed(Surv(time, delta)~x[,,drop=FALSE], data=data, t=t,
				lambda.identical=lambda.identical, alpha.identical=alpha.identical,alpha.fixed=alpha.fixed, est.var=FALSE)$estimate[,1],silent=TRUE)
			if(!grepl("Error",aux)[1])
			{
				par.last=c(aux,t[-1])
				while(iter<=max.iter & dif>prec)
				{
					aux.t=fit.pweibull.t(t[-1], formula, data, theta=aux, lambda.identical, alpha.identical, alpha.fixed)
					t=c(0,aux.t)
					aux=fit.pweibull.fixed(formula, data=data, t=t, lambda.identical=lambda.identical, 
						alpha.identical=alpha.identical,alpha.fixed=alpha.fixed, est.var=FALSE)$estimate[,1]
					par.new=c(aux,t[-1])
					dif=max(abs(par.last-par.new))	
					par.last=par.new
					iter=iter+1
				}
			}
		}
	}
	if(L==1) t=c(0)
	}

aux=fit.pweibull.fixed(formula, data=data, t=t, lambda.identical=lambda.identical, alpha.identical=alpha.identical, alpha.fixed=alpha.fixed)
if(is.null(t.or)){aux$AIC=aux$AIC+2*(length(t)-1);aux$BIC=aux$BIC+length(time)*(length(t)-1)}
aux
}