% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caterpillar_plot.R
\name{caterpillar_plot}
\alias{caterpillar_plot}
\title{Get a caterpillar plot to display confidence intervals for standardized measures}
\usage{
caterpillar_plot(
  CI,
  point_size = 2,
  point_color = "#475569",
  refline_value = NULL,
  refline_color = "#64748b",
  refline_size = 1,
  refline_type = "dashed",
  errorbar_width = 0,
  errorbar_size = 0.5,
  errorbar_alpha = 0.5,
  errorbar_color = "#94a3b8",
  use_flag = FALSE,
  orientation = "vertical",
  flag_color = c("#E69F00", "#56B4E9", "#009E73")
)
}
\arguments{
\item{CI}{a dataframe from \code{confint} function containing the standardized measure values, along with their confidence intervals lower and upper bounds.}

\item{point_size}{size of the points in the caterpillar plot. The default value is 2.}

\item{point_color}{color of the points in the plot. The default value is "#475569".}

\item{refline_value}{value of the horizontal reference line, for which the standardized measures are compared. The default value is NULL.}

\item{refline_color}{color of the reference line. The default value is "#64748b".}

\item{refline_size}{size of the reference line. The default value is 1.}

\item{refline_type}{line type for the reference line. The default value is "dashed".}

\item{errorbar_width}{the width of the error bars (horizontal ends of the CI bars). The default value is 0.}

\item{errorbar_size}{the thickness of the error bars. The default value is 0.5.}

\item{errorbar_alpha}{transparency level for the error bars. A value between 0 and 1, where 0 is completely transparent and 1 is fully opaque. The default value is 0.5.}

\item{errorbar_color}{color of the error bars. The default value is "#94a3b8".}

\item{use_flag}{logical; if \code{TRUE}, the error bars are colored to show providers' flags based on their performance. The default is \code{FALSE}.}

\item{orientation}{a string specifies the orientation of the caterpillar plot:
\describe{
\item{"vertical"}{(default) providers on the x‑axis and values on the y‑axis.}
\item{"horizontal"}{providers on the y‑axis and values on the x‑axis.}
}}

\item{flag_color}{vector of colors used for flagging providers when \code{use_flag = TRUE}. The default value is \code{c("#E69F00", "#56B4E9", "#009E73")}.}
}
\value{
A ggplot object which is a caterpillar plot for the standardized measures.
}
\description{
Generate a caterpillar plot for standardized measures from different models using a provided CI dataframe.
}
\details{
This function creates a caterpillar plot to visualize the standardized measures (indirect or direct).
The input \code{CI} must be a dataframe output from package \code{pprof}'s \code{confint} function.
Each provider's standardized measure value is represented as a point, and a reference line is shown at the value specified by \code{refline_value} (default is NULL).
If \code{refline_value} is not specified, for linear FE or RE models with indirect or direct standardized differences, it will be set to 0;
for logistic FE models with indirect or direct ratios, it will be set to 1;
and for logistic FE with indirect or direct rates, it will be set to the population rate, which represents the average rate across all observations.

Confidence intervals (CI) are displayed as error bars: for \code{alternative = "two.sided"}, two-sided confidence intervals are shown;
for \code{alternative = "greater"}, error bars extend from the lower bound to the standardized measure values;
and for \code{alternative = "less"}, they extend from the standardized measure values to the upper bound.
For cases where one side of the confidence interval is infinite, that side only extends to the standardized measure.
For example, in a logistic fixed effect model, if a provider has all 0s or all 1s, one side of the confidence interval will be infinite.

When \code{use_flag = TRUE}, the plot will use colors specified by \code{flag_color} to show the flags of providers.
Each error bar will be colored to reflect the flag, making it easy to identify providers with different performance levels.
When \code{use_flag = FALSE}, all error bars will have the same color, specified by \code{errorbar_color}.
This provides a simpler visualization without flagging individual providers.
}
\examples{
data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
fit_linear <- linear_fe(Y = outcome, Z = covar, ProvID = ProvID)
CI_linear <- confint(fit_linear)
caterpillar_plot(CI_linear$CI.indirect, use_flag = TRUE,
                 errorbar_width = 0.5, errorbar_size = 1)

data(ExampleDataBinary)
fit_logis <- logis_fe(Y = ExampleDataBinary$Y,
                      Z = ExampleDataBinary$Z,
                      ProvID = ExampleDataBinary$ProvID, message = FALSE)
CI_logis <- confint(fit_logis)
caterpillar_plot(CI_logis$CI.indirect_ratio, use_flag = TRUE,
                 errorbar_width = 0.5, errorbar_size = 1,
                 orientation = "horizontal")

}
\seealso{
\code{\link{confint.linear_fe}}, \code{\link{confint.linear_re}}, \code{\link{confint.logis_fe}}
}
